/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.wait;

import hmi.bml.core.Behaviour;
import hmi.bml.core.WaitBehaviour;
import hmi.elckerlyc.AbstractPlanner;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.pegboard.BMLBlockPeg;
import hmi.elckerlyc.pegboard.OffsetPeg;
import hmi.elckerlyc.pegboard.TimePeg;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import hmi.elckerlyc.wait.TimedWaitUnit;
import java.util.ArrayList;
import java.util.List;

public class WaitPlanner
extends AbstractPlanner<TimedWaitUnit> {
    public WaitPlanner(FeedbackManager bfm, PlanManager<TimedWaitUnit> planManager) {
        super(bfm, planManager);
    }

    private void validateSacs(Behaviour b, List<TimePegAndConstraint> sacs) throws BehaviourPlanningException {
        if (sacs.size() > 2) {
            throw new BehaviourPlanningException(b, "More than two synchronization constraints: " + sacs + " on wait behaviour " + b);
        }
        for (TimePegAndConstraint sac : sacs) {
            if (sac.syncId.equals("start") || sac.syncId.equals("end")) continue;
            throw new BehaviourPlanningException(b, "Wait behavior " + b + " has a synchronization constraint other than start or end.");
        }
    }

    @Override
    public List<SyncAndTimePeg> addBehaviour(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sacs, TimedWaitUnit wu) throws BehaviourPlanningException {
        if (wu == null) {
            wu = new TimedWaitUnit(this.fbManager, bbPeg, b.getBmlId(), b.id);
        }
        this.validateSacs(b, sacs);
        this.planManager.addPlanUnit(wu);
        ArrayList<SyncAndTimePeg> list = new ArrayList<SyncAndTimePeg>();
        for (TimePegAndConstraint sac : sacs) {
            if (sac.syncId.equals("start")) {
                wu.setStartPeg(sac.peg);
            }
            if (sac.syncId.equals("end")) {
                wu.setEndPeg(sac.peg);
            }
            list.add(new SyncAndTimePeg(b.getBmlId(), b.id, sac.syncId, sac.peg));
        }
        return list;
    }

    @Override
    public TimedWaitUnit resolveSynchs(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sacs) throws BehaviourPlanningException {
        this.validateSacs(b, sacs);
        TimedWaitUnit wu = new TimedWaitUnit(this.fbManager, bbPeg, b.getBmlId(), b.id);
        TimePegAndConstraint sacStart = null;
        TimePegAndConstraint sacEnd = null;
        float maxDur = b.getFloatParameterValue("max-wait");
        for (TimePegAndConstraint sac : sacs) {
            if (sac.syncId.equals("start")) {
                sacStart = sac;
            }
            if (!sac.syncId.equals("end")) continue;
            sacEnd = sac;
        }
        TimePeg startPeg = null;
        if (sacStart != null) {
            if (sacStart.peg.getGlobalValue() == -1.7976931348623157E308) {
                if (sacEnd == null || sacEnd.peg.getGlobalValue() == -1.7976931348623157E308 || maxDur <= 0.0f) {
                    sacStart.peg.setLocalValue(0.0);
                } else {
                    sacStart.peg.setGlobalValue(sacEnd.peg.getGlobalValue() - (double)maxDur);
                }
            }
            startPeg = sacStart.offset == 0.0 ? sacStart.peg : new OffsetPeg(sacStart.peg, -sacStart.offset);
        } else if (sacEnd != null && sacEnd.peg.getGlobalValue() != -1.7976931348623157E308 && maxDur > 0.0f) {
            startPeg = new OffsetPeg(sacEnd.peg, -maxDur);
        } else {
            startPeg = new TimePeg(bbPeg);
            startPeg.setLocalValue(0.0);
        }
        wu.setStartPeg(startPeg);
        if (sacEnd == null) {
            if (maxDur <= 0.0f) {
                TimePeg p = new TimePeg(bbPeg);
                wu.setEndPeg(p);
            } else {
                wu.setEndPeg(new OffsetPeg(startPeg, maxDur));
            }
        } else {
            if (sacEnd.peg.getGlobalValue() == -1.7976931348623157E308 && maxDur > 0.0f) {
                sacEnd.peg.setGlobalValue(startPeg.getGlobalValue() + (double)maxDur);
            }
            wu.setEndPeg(sacEnd.peg);
        }
        return wu;
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedBehaviours() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(WaitBehaviour.class);
        return list;
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedDescriptionExtensions() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        return list;
    }

    @Override
    public double getRigidity(Behaviour beh) {
        return 1.0;
    }
}

