/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.wait;

import hmi.bml.BMLGestureSync;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.pegboard.BMLBlockPeg;
import hmi.elckerlyc.pegboard.TimePeg;
import hmi.elckerlyc.planunit.TimedAbstractPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitPlayException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedWaitUnit
extends TimedAbstractPlanUnit {
    private TimePeg startPeg;
    private TimePeg endPeg;
    private static final Logger logger = LoggerFactory.getLogger((String)TimedWaitUnit.class.getName());

    protected TimedWaitUnit(FeedbackManager bfm, BMLBlockPeg bmlPeg, String bmlId, String id) {
        super(bfm, bmlPeg, bmlId, id);
    }

    public void setStartPeg(TimePeg startPeg) {
        this.startPeg = startPeg;
    }

    public void setEndPeg(TimePeg endPeg) {
        this.endPeg = endPeg;
    }

    @Override
    public double getStartTime() {
        return this.startPeg.getGlobalValue();
    }

    @Override
    public double getEndTime() {
        if (this.endPeg == null) {
            return -1.7976931348623157E308;
        }
        return this.endPeg.getGlobalValue();
    }

    @Override
    public double getRelaxTime() {
        return this.getEndTime();
    }

    @Override
    public boolean hasValidTiming() {
        if (this.startPeg == null) {
            return false;
        }
        if (this.startPeg.getGlobalValue() == -1.7976931348623157E308) {
            return false;
        }
        if (this.endPeg == null) {
            return true;
        }
        if (this.endPeg.getGlobalValue() == -1.7976931348623157E308) {
            return true;
        }
        return this.startPeg.getGlobalValue() < this.endPeg.getGlobalValue();
    }

    @Override
    public void startUnit(double time) {
        this.sendFeedback("start", time);
    }

    @Override
    protected void playUnit(double time) throws TimedPlanUnitPlayException {
    }

    @Override
    protected void stopUnit(double time) throws TimedPlanUnitPlayException {
        this.sendFeedback("end", time);
    }

    @Override
    public double getPreferedDuration() {
        if (this.getEndTime() != -1.7976931348623157E308 && this.getStartTime() != -1.7976931348623157E308) {
            return this.getEndTime() - this.getStartTime();
        }
        return 0.0;
    }

    @Override
    public TimePeg getTimePeg(String syncId) {
        if (syncId.equals("start")) {
            return this.startPeg;
        }
        if (syncId.equals("end")) {
            return this.endPeg;
        }
        return null;
    }

    @Override
    public void setTimePeg(String syncId, TimePeg peg) {
        if (BMLGestureSync.isBMLSync((String)syncId)) {
            if (BMLGestureSync.get((String)syncId).isAfter(BMLGestureSync.STROKE)) {
                this.setEndPeg(peg);
            } else {
                this.setStartPeg(peg);
            }
        } else {
            logger.warn("Can't set TimePeg on non-BML sync {}", (Object)syncId);
        }
    }
}

