/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.scheduler;

import hmi.bml.core.BMLBlockComposition;
import hmi.bml.core.Behaviour;
import hmi.bml.core.BehaviourBlock;
import hmi.bml.parser.Constraint;
import hmi.bml.parser.SyncPoint;
import hmi.elckerlyc.pegboard.BMLBlockPeg;
import hmi.elckerlyc.pegboard.PegBoard;
import hmi.elckerlyc.scheduler.BMLScheduler;
import hmi.elckerlyc.scheduler.SchedulingStrategy;
import hmi.elckerlyc.scheduler.SmartBodySchedulingStrategy;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SortedSmartBodySchedulingStrategy
implements SchedulingStrategy {
    private SmartBodySchedulingStrategy strategy;

    public SortedSmartBodySchedulingStrategy(PegBoard pb) {
        this.strategy = new SmartBodySchedulingStrategy(pb);
    }

    @Override
    public void schedule(BMLBlockComposition mechanism, BehaviourBlock bb, BMLBlockPeg bmlBlockPeg, BMLScheduler scheduler, double schedulingTime) {
        Collections.sort(bb.behaviours, new SimpleBehaviourComparator(bb.behaviours, scheduler));
        this.strategy.schedule(mechanism, bb, bmlBlockPeg, scheduler, schedulingTime);
    }

    private static class SimpleBehaviourComparator
    implements Comparator<Behaviour> {
        private final BMLScheduler scheduler;
        private Map<Behaviour, Integer> behOrder = new HashMap<Behaviour, Integer>();

        public SimpleBehaviourComparator(List<Behaviour> behs, BMLScheduler s) {
            this.scheduler = s;
            int i = 0;
            for (Behaviour b : behs) {
                this.behOrder.put(b, i);
                ++i;
            }
        }

        private int getAbsoluteConstraints(Behaviour b) {
            int absconstr = 0;
            for (Constraint c : this.scheduler.getParser().getConstraints(b.getBmlId(), b.id)) {
                boolean isHard = false;
                for (SyncPoint s : c.getTargets()) {
                    if (s.getBehaviourId() != null) continue;
                    isHard = true;
                }
                if (!isHard) continue;
                ++absconstr;
            }
            return absconstr;
        }

        private boolean nonRigidLoop(Behaviour b1, Behaviour b2) {
            boolean nonRigid = true;
            boolean inLoop = false;
            for (List ugLoops : this.scheduler.getParser().getUngroundedLoops(b1.getBmlId(), b1.id)) {
                if (!ugLoops.contains(b2)) continue;
                inLoop = true;
                for (Behaviour beh : ugLoops) {
                    if (!(this.scheduler.getRigidity(beh) >= 1.0)) continue;
                    nonRigid = false;
                }
            }
            return nonRigid && inLoop;
        }

        @Override
        public int compare(Behaviour o1, Behaviour o2) {
            int o1AbsConstr = this.getAbsoluteConstraints(o1);
            int o2AbsConstr = this.getAbsoluteConstraints(o2);
            double rig1 = this.scheduler.getRigidity(o1);
            double rig2 = this.scheduler.getRigidity(o2);
            if (rig1 >= 1.0 && rig2 < 1.0 && o1AbsConstr > 0) {
                return -1;
            }
            if (rig2 >= 1.0 && rig1 < 1.0 && o2AbsConstr > 0) {
                return 1;
            }
            if (rig1 >= 1.0 && rig2 < 1.0 && this.nonRigidLoop(o1, o2)) {
                return -1;
            }
            if (rig2 >= 1.0 && rig1 < 1.0 && this.nonRigidLoop(o2, o1)) {
                return 1;
            }
            if (rig1 <= 0.0 && rig2 > 0.0) {
                return 1;
            }
            if (rig2 <= 0.0 && rig1 > 0.0) {
                return -1;
            }
            if (this.behOrder.get(o1) < this.behOrder.get(o2)) {
                return -1;
            }
            if (this.behOrder.get(o2) < this.behOrder.get(o1)) {
                return 1;
            }
            return 0;
        }
    }
}

