/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.scheduler;

import hmi.bml.core.BMLBlockComposition;
import hmi.bml.core.Behaviour;
import hmi.bml.core.BehaviourBlock;
import hmi.bml.ext.bmlt.BMLTBMLBehaviorAttributes;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLWarningFeedback;
import hmi.bml.parser.Constraint;
import hmi.bml.parser.SyncPoint;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.Engine;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.anticipator.Anticipator;
import hmi.elckerlyc.pegboard.BMLBlockPeg;
import hmi.elckerlyc.pegboard.OffsetPeg;
import hmi.elckerlyc.pegboard.PegBoard;
import hmi.elckerlyc.pegboard.TimePeg;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.scheduler.BMLScheduler;
import hmi.elckerlyc.scheduler.SchedulingStrategy;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartBodySchedulingStrategy
implements SchedulingStrategy {
    private final PegBoard pegBoard;
    private static final Logger logger = LoggerFactory.getLogger((String)SmartBodySchedulingStrategy.class.getName());

    public SmartBodySchedulingStrategy(PegBoard pb) {
        this.pegBoard = pb;
    }

    @Override
    public void schedule(BMLBlockComposition mechanism, BehaviourBlock bb, BMLBlockPeg bmlBlockPeg, BMLScheduler scheduler, double scheduleTime) {
        ArrayList<Behaviour> scheduledBehaviors = new ArrayList<Behaviour>();
        HashMap<Behaviour, ArrayList<TimePegAndConstraint>> syncMap = new HashMap<Behaviour, ArrayList<TimePegAndConstraint>>();
        for (Behaviour b : bb.behaviours) {
            BMLTBMLBehaviorAttributes bmltAttr = (BMLTBMLBehaviorAttributes)bb.getBMLBehaviorAttributeExtension(BMLTBMLBehaviorAttributes.class);
            this.scheduleBehaviour(mechanism, bmltAttr.allowExternalRefs(), bb.id, bmlBlockPeg, scheduler, scheduleTime, scheduledBehaviors, syncMap, b);
        }
        boolean moving = true;
        ArrayList<Behaviour> behToRemove = new ArrayList<Behaviour>();
        block1: while (moving) {
            moving = false;
            for (Behaviour b : scheduledBehaviors) {
                for (TimePegAndConstraint tpac : syncMap.get(b)) {
                    double t = this.pegBoard.getRelativePegTime(bb.id, tpac.peg) - tpac.offset;
                    if (!(t < -1.0E-6) || t == -1.7976931348623157E308) continue;
                    logger.debug("negative time: {}:{}", (Object)b.id, (Object)tpac.syncId);
                    logger.debug("Value: {} Offset: {}", (Object)tpac.peg.getGlobalValue(), (Object)tpac.offset);
                    double move = -t;
                    if (!tpac.peg.isAbsoluteTime()) {
                        this.movePeg(move, b, syncMap);
                        moving = true;
                        break;
                    }
                    if (tpac.peg.getGlobalValue() < 0.0 || tpac.peg.getBmlId().equals(bb.id)) {
                        String bmlId = b.getBmlId();
                        HashSet<String> droppedBehaviours = new HashSet<String>();
                        droppedBehaviours.add(b.id);
                        HashSet modifiedConstraints = new HashSet();
                        String warningText = "Can't satisfy time constraints " + tpac + " on <" + b.getXMLTag() + ">, behavior ommitted";
                        scheduler.exception(new BMLExceptionFeedback(bmlId, scheduleTime, droppedBehaviours, modifiedConstraints, warningText, false));
                        behToRemove.add(b);
                        break;
                    }
                    logger.warn("Absolute constraints require behavior {}:{} to start earlier than its BML block", (Object)b.getBmlId(), (Object)b.id);
                    break;
                }
                if (!moving) continue;
                continue block1;
            }
        }
        for (Behaviour b : behToRemove) {
            scheduler.removeBehaviour(b.getBmlId(), b.id);
        }
    }

    private void scheduleBehaviour(BMLBlockComposition mechanism, boolean allowExternalRefs, String bmlId, BMLBlockPeg bmlBlockPeg, BMLScheduler scheduler, double scheduleTime, ArrayList<Behaviour> scheduledBehaviors, HashMap<Behaviour, ArrayList<TimePegAndConstraint>> syncMap, Behaviour b) {
        Engine eng;
        ArrayList<TimePegAndConstraint> syncList = new ArrayList<TimePegAndConstraint>();
        for (Constraint c : scheduler.getParser().getConstraints()) {
            ArrayList<ConstrInfo> constraintInfo = new ArrayList<ConstrInfo>();
            for (SyncPoint s : c.getTargets()) {
                if (s.getBehaviourId() == null || !s.getBehaviourId().equals(b.id) || !s.getBmlId().equals(b.getBmlId())) continue;
                double offset = s.getOffset();
                String syncId = s.getName();
                constraintInfo.add(new ConstrInfo(syncId, offset));
                logger.debug("Constraint info:{} sync:{} offset:{}", new Object[]{b, syncId, offset});
            }
            for (ConstrInfo ci : constraintInfo) {
                boolean syncExists = false;
                for (Behaviour b2 : scheduledBehaviors) {
                    for (TimePegAndConstraint said : syncMap.get(b2)) {
                        if (said.constr != c) continue;
                        syncList.add(new TimePegAndConstraint(ci.syncId, said.peg, c, ci.offset));
                        syncExists = true;
                        break;
                    }
                    if (!syncExists) continue;
                    break;
                }
                if (syncExists) continue;
                boolean isStaticOrAnticipator = false;
                for (SyncPoint s : c.getTargets()) {
                    if (s.getBehaviourId() == null) {
                        if (s.getBmlId().equals("anticipators")) {
                            String[] str = s.getName().split(":");
                            if (str.length == 2 && !str[0].equals("bml")) {
                                Anticipator ap = scheduler.getAnticipator(str[0]);
                                isStaticOrAnticipator = true;
                                if (ap != null) {
                                    TimePeg sp = ap.getSynchronisationPoint(str[1]);
                                    if (sp == null) {
                                        HashSet<String> modifiedBehaviours = new HashSet<String>();
                                        modifiedBehaviours.add(b.id);
                                        HashSet modifiedConstraints = new HashSet();
                                        String warningText = "Unknown anticipator synchronization point " + s.getName() + " sync ignored.";
                                        scheduler.warn(new BMLWarningFeedback(bmlId, scheduleTime, modifiedBehaviours, modifiedConstraints, warningText));
                                        break;
                                    }
                                    syncList.add(new TimePegAndConstraint(ci.syncId, sp, c, ci.offset - s.offset));
                                    logger.debug("Link to anticipator: {} at time {} with offset {}", new Object[]{str[1], sp.getGlobalValue(), ci.offset});
                                    sp.setAbsoluteTime(true);
                                    break;
                                }
                                HashSet<String> modifiedBehaviours = new HashSet<String>();
                                modifiedBehaviours.add(b.id);
                                HashSet modifiedConstraints = new HashSet();
                                String warningText = "Unknown sync point " + s.getName() + " sync ignored.";
                                scheduler.warn(new BMLWarningFeedback(bmlId, scheduleTime, modifiedBehaviours, modifiedConstraints, warningText));
                                break;
                            }
                        } else {
                            isStaticOrAnticipator = true;
                            TimePeg sync = new TimePeg(bmlBlockPeg);
                            sync.setAbsoluteTime(true);
                            sync.setLocalValue(s.getOffset());
                            syncList.add(new TimePegAndConstraint(ci.syncId, sync, c, ci.offset));
                            break;
                        }
                    }
                    if (s.getBmlId().equals(bmlId)) continue;
                    if (allowExternalRefs) {
                        isStaticOrAnticipator = true;
                        TimePeg sp = this.pegBoard.getTimePeg(s.getBmlId(), s.getBehaviourId(), s.getName());
                        syncList.add(new TimePegAndConstraint(ci.syncId, sp, c, ci.offset - s.offset));
                        logger.debug("Link to behavior in other block: {}:{} at time {} with offset {}", new Object[]{s.getBmlId(), s.getBehaviourId(), sp.getGlobalValue(), ci.offset - s.offset});
                        sp.setAbsoluteTime(true);
                        break;
                    }
                    HashSet<String> modifiedBehaviours = new HashSet<String>();
                    HashSet modifiedConstraints = new HashSet();
                    modifiedBehaviours.add(b.id);
                    String warningText = "Unknown sync point " + s.getBmlId() + ":" + s.getBehaviourId() + ":" + s.getName() + " sync ignored.";
                    scheduler.warn(new BMLWarningFeedback(bmlId, scheduleTime, modifiedBehaviours, modifiedConstraints, warningText));
                    break;
                }
                if (isStaticOrAnticipator) continue;
                TimePeg sync = new TimePeg(bmlBlockPeg);
                sync.setGlobalValue(-1.7976931348623157E308);
                syncList.add(new TimePegAndConstraint(ci.syncId, sync, c, ci.offset));
            }
        }
        boolean resolveStart = true;
        for (TimePegAndConstraint sac : syncList) {
            if (!sac.syncId.equals("start")) continue;
            resolveStart = false;
            break;
        }
        if (resolveStart) {
            TimePeg temp = new TimePeg(bmlBlockPeg);
            OffsetPeg sync = new OffsetPeg(temp, 0.0, bmlBlockPeg);
            boolean offsetRes = false;
            if (syncList.size() > 0) {
                offsetRes = true;
            }
            syncList.add(new TimePegAndConstraint("start", sync, new Constraint(), 0.0, offsetRes));
        }
        if ((eng = scheduler.getEngine(b.getClass())) != null) {
            try {
                TimedPlanUnit planElement = eng.resolveSynchs(bmlBlockPeg, b, syncList);
                List<SyncAndTimePeg> satp = eng.addBehaviour(bmlBlockPeg, b, syncList, planElement);
                this.pegBoard.addTimePegs(satp);
            }
            catch (BehaviourPlanningException ex) {
                HashSet<String> droppedBehaviours = new HashSet<String>();
                droppedBehaviours.add(b.id);
                HashSet modifiedConstraints = new HashSet();
                String warningText = ex.getMessage();
                scheduler.exception(new BMLExceptionFeedback(bmlId, scheduleTime, droppedBehaviours, modifiedConstraints, warningText, false));
                return;
            }
        } else {
            HashSet<String> droppedBehaviours = new HashSet<String>();
            droppedBehaviours.add(b.id);
            HashSet modifiedConstraints = new HashSet();
            String warningText = "No planner found to plan behavior of type <" + b.getXMLTag() + ">, behavior ommitted";
            scheduler.exception(new BMLExceptionFeedback(bmlId, scheduleTime, droppedBehaviours, modifiedConstraints, warningText, false));
            return;
        }
        syncMap.put(b, syncList);
        scheduledBehaviors.add(b);
    }

    private boolean moveBehavior(double move, Behaviour b, ArrayList<TimePeg> movedPegs, HashMap<Behaviour, ArrayList<TimePegAndConstraint>> syncMap) {
        boolean pegAdded = false;
        TimePeg firstAbsolute = null;
        for (TimePegAndConstraint tpac : syncMap.get(b)) {
            if (!tpac.peg.isAbsoluteTime() || firstAbsolute != null && !(firstAbsolute.getGlobalValue() > tpac.peg.getGlobalValue())) continue;
            firstAbsolute = tpac.peg;
        }
        for (TimePegAndConstraint tpac : syncMap.get(b)) {
            if (movedPegs.contains(tpac.peg.getLink()) || firstAbsolute != null && !(firstAbsolute.getGlobalValue() < tpac.peg.getGlobalValue())) continue;
            logger.debug("Moving {} : {} from {} to {}", new Object[]{b.id, tpac.syncId, tpac.peg.getGlobalValue(), tpac.peg.getGlobalValue() + move});
            tpac.peg.setGlobalValue(tpac.peg.getGlobalValue() + move);
            movedPegs.add(tpac.peg.getLink());
            pegAdded = true;
        }
        return pegAdded;
    }

    private void movePeg(double move, Behaviour b, HashMap<Behaviour, ArrayList<TimePegAndConstraint>> syncMap) {
        ArrayList<TimePeg> movedPegs = new ArrayList<TimePeg>();
        ArrayList<Behaviour> movedBehaviors = new ArrayList<Behaviour>();
        this.moveBehavior(move, b, movedPegs, syncMap);
        movedBehaviors.add(b);
        boolean pegAdded = true;
        block0: while (pegAdded) {
            pegAdded = false;
            for (Map.Entry<Behaviour, ArrayList<TimePegAndConstraint>> behTpac : syncMap.entrySet()) {
                Behaviour beh = behTpac.getKey();
                if (!movedBehaviors.contains(beh)) {
                    for (TimePegAndConstraint tpac : behTpac.getValue()) {
                        if (!movedPegs.contains(tpac.peg.getLink())) continue;
                        pegAdded = this.moveBehavior(move, beh, movedPegs, syncMap);
                        movedBehaviors.add(beh);
                        if (!pegAdded) continue;
                        break;
                    }
                }
                if (!pegAdded) continue;
                continue block0;
            }
        }
    }

    private static class ConstrInfo {
        String syncId;
        double offset;

        public ConstrInfo(String s, double o) {
            this.syncId = s;
            this.offset = o;
        }
    }
}

