/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.scheduler;

import hmi.bml.core.Behaviour;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.SyncPointNotFoundException;
import hmi.elckerlyc.pegboard.BMLBlockPeg;
import hmi.elckerlyc.pegboard.OffsetPeg;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import hmi.elckerlyc.scheduler.UniModalResolver;
import java.util.ArrayList;
import java.util.List;

public class LinearStretchResolver
implements UniModalResolver {
    private void linkSynchs(TimedPlanUnit tmu, List<TimePegAndConstraint> sacs) {
        for (TimePegAndConstraint s : sacs) {
            for (String syncId : tmu.getAvailableSyncs()) {
                if (!s.syncId.equals(syncId)) continue;
                if (s.offset == 0.0) {
                    tmu.setTimePeg(syncId, s.peg);
                    continue;
                }
                tmu.setTimePeg(syncId, new OffsetPeg(s.peg, -s.offset));
            }
        }
    }

    private void validateSyncs(TimedPlanUnit pu, Behaviour b, List<TimePegAndConstraint> sac) throws BehaviourPlanningException {
        for (TimePegAndConstraint s : sac) {
            if (pu.getAvailableSyncs().contains(s.syncId)) continue;
            throw new BehaviourPlanningException(b, "Sync id " + s.syncId + " not available for TimedPlanUnit " + pu);
        }
    }

    @Override
    public void resolveSynchs(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sac, TimedPlanUnit pu) throws BehaviourPlanningException {
        this.validateSyncs(pu, b, sac);
        ArrayList<TimePegAndConstraint> sortedSac = new ArrayList<TimePegAndConstraint>();
        block20: for (String syncId : pu.getAvailableSyncs()) {
            for (TimePegAndConstraint s : sac) {
                if (!s.syncId.equals(syncId)) continue;
                sortedSac.add(s);
                continue block20;
            }
        }
        this.linkSynchs(pu, sortedSac);
        int sections = 0;
        double totalStretch = 0.0;
        TimePegAndConstraint sPrev = null;
        for (TimePegAndConstraint s : sortedSac) {
            if (s.peg.getGlobalValue() == -1.7976931348623157E308) continue;
            if (sPrev != null) {
                double duration = pu.getTime(s.syncId) - pu.getTime(sPrev.syncId);
                double startKey = 0.0;
                double endKey = 0.0;
                for (String syncId : pu.getAvailableSyncs()) {
                    if (pu.getTimePeg(syncId) == null) continue;
                    if (pu.getTimePeg(syncId).getLink() == sPrev.peg.getLink()) {
                        try {
                            startKey = pu.getRelativeTime(syncId);
                        }
                        catch (SyncPointNotFoundException e) {
                            throw new BehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                        }
                    }
                    if (pu.getTimePeg(syncId).getLink() != s.peg.getLink()) continue;
                    try {
                        startKey = pu.getRelativeTime(syncId);
                    }
                    catch (SyncPointNotFoundException e) {
                        throw new BehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                    }
                }
                double nominalDuration = (endKey - startKey) * pu.getPreferedDuration();
                if (!(nominalDuration > 0.0)) continue;
                totalStretch += duration / nominalDuration;
                ++sections;
                continue;
            }
            sPrev = s;
        }
        double avgStretch = 1.0;
        if (sections > 0) {
            avgStretch = totalStretch / (double)sections;
        }
        if (sortedSac.size() > 0) {
            TimePegAndConstraint sacStart = sortedSac.get(0);
            if (sacStart.peg.getGlobalValue() == -1.7976931348623157E308) {
                TimePegAndConstraint sacNext = null;
                for (TimePegAndConstraint s : sortedSac) {
                    if (s.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                    sacNext = s;
                    break;
                }
                if (sacNext == null) {
                    sacStart.peg.setLocalValue(0.0);
                } else {
                    double nextKey;
                    try {
                        nextKey = pu.getRelativeTime(sacNext.syncId);
                    }
                    catch (SyncPointNotFoundException e) {
                        throw new BehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                    }
                    double nextTime = pu.getTime(sacNext.syncId);
                    double tStart = nextTime - nextKey * avgStretch * pu.getPreferedDuration();
                    if (sacStart.resolveAsStartOffset) {
                        OffsetPeg os = (OffsetPeg)sacStart.peg;
                        os.setLink(pu.getTimePeg(sacNext.syncId));
                        os.setOffset(tStart - nextTime);
                    } else {
                        sacStart.peg.setGlobalValue(tStart + sacStart.offset);
                    }
                }
            }
            TimePegAndConstraint sacEnd = sortedSac.get(sortedSac.size() - 1);
            if (sacEnd.peg.getGlobalValue() == -1.7976931348623157E308) {
                TimePegAndConstraint sacPrev = null;
                for (TimePegAndConstraint s : sortedSac) {
                    if (s.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                    sacPrev = s;
                }
                if (sacPrev == null) {
                    sacEnd.peg.setGlobalValue(pu.getPreferedDuration());
                } else {
                    double keyCurr;
                    double keyPrev;
                    try {
                        keyPrev = pu.getRelativeTime(sacPrev.syncId);
                    }
                    catch (SyncPointNotFoundException e) {
                        throw new BehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                    }
                    double keyNext = 1.0;
                    try {
                        keyCurr = pu.getRelativeTime(sacEnd.syncId);
                    }
                    catch (SyncPointNotFoundException e) {
                        throw new BehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                    }
                    double timePrev = pu.getTime(sacPrev.syncId);
                    double timeNext = timePrev + (keyNext - keyPrev) * avgStretch * pu.getPreferedDuration();
                    sacEnd.peg.setGlobalValue(timePrev + (keyCurr - keyPrev) * (timeNext - timePrev) / (keyNext - keyPrev) + sacEnd.offset);
                }
            }
            TimePegAndConstraint sacPrev = sacStart;
            TimePegAndConstraint sacNext = null;
            for (TimePegAndConstraint s : sortedSac) {
                if (s.peg.getGlobalValue() == -1.7976931348623157E308) {
                    double keyCurr;
                    double keyNext;
                    double keyPrev;
                    for (TimePegAndConstraint s2 : sortedSac.subList(sortedSac.indexOf(s), sortedSac.size())) {
                        if (s2.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                        sacNext = s2;
                        break;
                    }
                    try {
                        keyPrev = pu.getRelativeTime(sacPrev.syncId);
                    }
                    catch (SyncPointNotFoundException e) {
                        throw new BehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                    }
                    try {
                        keyNext = pu.getRelativeTime(sacNext.syncId);
                    }
                    catch (SyncPointNotFoundException e) {
                        throw new BehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                    }
                    try {
                        keyCurr = pu.getRelativeTime(s.syncId);
                    }
                    catch (SyncPointNotFoundException e) {
                        throw new BehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                    }
                    double timePrev = pu.getTime(sacPrev.syncId);
                    double timeNext = pu.getTime(sacNext.syncId);
                    s.peg.setGlobalValue(timePrev + (keyCurr - keyPrev) * (timeNext - timePrev) / (keyNext - keyPrev) + s.offset);
                }
                sacPrev = s;
            }
            sacEnd = sortedSac.get(sortedSac.size() - 1);
            if (!sacEnd.syncId.equals("end") && pu.getPreferedDuration() > 0.0) {
                double keyEnd;
                double keyPrev;
                try {
                    keyPrev = pu.getRelativeTime(sacEnd.syncId);
                }
                catch (SyncPointNotFoundException e) {
                    throw new BehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                }
                try {
                    keyEnd = pu.getRelativeTime("end");
                }
                catch (SyncPointNotFoundException e) {
                    throw new BehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                }
                OffsetPeg op = new OffsetPeg(pu.getTimePeg(sacEnd.syncId), (keyEnd - keyPrev) * avgStretch * pu.getPreferedDuration());
                pu.setTimePeg("end", op);
            }
        }
    }
}

