/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.scheduler;

import hmi.bml.core.BehaviourBlock;
import hmi.bml.ext.bmlt.BMLTBMLBehaviorAttributes;
import hmi.bml.ext.bmlt.BMLTSchedulingMechanism;
import hmi.elckerlyc.pegboard.BMLBlockPeg;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.scheduler.BMLScheduler;
import hmi.elckerlyc.scheduler.BMLTBlock;
import hmi.elckerlyc.scheduler.SchedulingHandler;
import hmi.elckerlyc.scheduler.SchedulingStrategy;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BMLTSchedulingHandler
implements SchedulingHandler {
    private final SchedulingStrategy strategy;
    private final Logger logger = LoggerFactory.getLogger((String)BMLTSchedulingHandler.class.getName());

    public BMLTSchedulingHandler(SchedulingStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void schedule(BehaviourBlock bb, BMLScheduler scheduler) {
        BMLTBMLBehaviorAttributes bmltAttr = (BMLTBMLBehaviorAttributes)bb.getBMLBehaviorAttributeExtension(BMLTBMLBehaviorAttributes.class);
        HashSet<String> appendAfter = new HashSet<String>();
        for (String bmlId : bmltAttr.getInterruptList()) {
            this.logger.debug("interrupting {}", (Object)bmlId);
            scheduler.interruptBlock(bmlId);
        }
        switch (BMLTSchedulingMechanism.parse((String)bb.getSchedulingMechanism().getNameStart())) {
            case REPLACE: {
                scheduler.reset();
                break;
            }
            case MERGE: {
                break;
            }
            case APPEND: {
                appendAfter.addAll(scheduler.getBMLBlocks());
                break;
            }
            case APPEND_AFTER: {
                appendAfter.addAll(bmltAttr.getAppendList());
                appendAfter.retainAll(scheduler.getBMLBlocks());
            }
        }
        double predictedStart = scheduler.predictEndTime(appendAfter);
        scheduler.planningStart(bb.id, predictedStart);
        BMLTBlock bbm = new BMLTBlock(bb.id, scheduler, appendAfter, bmltAttr.getOnStartList());
        BMLBlockPeg bmlBlockPeg = new BMLBlockPeg(bb.id, predictedStart);
        scheduler.addBMLBlockPeg(bmlBlockPeg);
        this.strategy.schedule(bb.getSchedulingMechanism(), bb, bmlBlockPeg, scheduler, scheduler.getSchedulingTime());
        this.logger.debug("Scheduling finished at: {}", (Object)scheduler.getSchedulingTime());
        scheduler.removeInvalidBehaviors(bb.id);
        predictedStart = scheduler.predictEndTime(appendAfter);
        scheduler.addBMLBlock(bbm);
        scheduler.planningFinished(bb.id, predictedStart, scheduler.predictEndTime(bb.id));
        if (bmltAttr.isPrePlanned()) {
            this.logger.debug("Preplanning {}.", (Object)bb.id);
            bbm.setState(TimedPlanUnitState.PENDING);
        } else {
            switch (BMLTSchedulingMechanism.parse((String)bb.getSchedulingMechanism().getNameStart())) {
                case REPLACE: 
                case MERGE: {
                    scheduler.startBlock(bb.id);
                    break;
                }
                case APPEND: 
                case APPEND_AFTER: {
                    bbm.setState(TimedPlanUnitState.LURKING);
                    scheduler.updateBMLBlocks();
                }
            }
        }
    }
}

