/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.scheduler;

import com.google.common.collect.ImmutableMap;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.scheduler.AbstractBMLBlock;
import hmi.elckerlyc.scheduler.BMLScheduler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BMLTBlock
extends AbstractBMLBlock {
    private final Set<String> appendSet = new CopyOnWriteArraySet<String>();
    private final Set<String> onStartSet = new CopyOnWriteArraySet<String>();
    private static final Logger logger = LoggerFactory.getLogger((String)BMLTBlock.class.getName());

    public Set<String> getOnStartSet() {
        return Collections.unmodifiableSet(this.onStartSet);
    }

    public BMLTBlock(String id, BMLScheduler s, Set<String> appendAfter, Set<String> onStart) {
        super(id, s);
        this.appendSet.addAll(appendAfter);
        this.onStartSet.addAll(onStart);
    }

    public BMLTBlock(String id, BMLScheduler s) {
        this(id, s, new HashSet<String>(), new HashSet<String>());
    }

    @Override
    public void start() {
        super.start();
        this.activateOnStartBlocks();
    }

    @Override
    public void update(ImmutableMap<String, TimedPlanUnitState> allBlocks) {
        if (this.state.get() == TimedPlanUnitState.LURKING) {
            this.updateFromLurking(allBlocks);
        } else if (this.state.get() == TimedPlanUnitState.IN_EXEC || this.state.get() == TimedPlanUnitState.SUBSIDING) {
            this.updateFromExecOrSubSiding();
        }
    }

    private void activateOnStartBlocks() {
        for (String id : this.getOnStartSet()) {
            if (!this.scheduler.getBMLBlockState(id).equals((Object)TimedPlanUnitState.PENDING)) continue;
            this.scheduler.activateBlock(id);
        }
    }

    private void updateFromLurking(ImmutableMap<String, TimedPlanUnitState> allBlocks) {
        this.appendSet.retainAll((Collection<?>)allBlocks.keySet());
        for (String apId : this.appendSet) {
            if (((TimedPlanUnitState)((Object)allBlocks.get((Object)apId))).isDone()) continue;
            return;
        }
        this.scheduler.startBlock(this.bmlId);
    }

    private void updateFromExecOrSubSiding() {
        if (this.state.get() != TimedPlanUnitState.SUBSIDING && this.isSubsiding()) {
            this.state.set(TimedPlanUnitState.SUBSIDING);
            this.scheduler.updateBMLBlocks();
        }
        if (this.state.get() != TimedPlanUnitState.DONE && this.isFinished()) {
            logger.debug("bml block {} finished", (Object)this.bmlId);
            this.finish();
        }
    }
}

