/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.scheduler;

import asap.utils.SchedulingClock;
import com.google.common.collect.ImmutableSet;
import hmi.bml.core.Behaviour;
import hmi.bml.core.BehaviourBlock;
import hmi.bml.ext.bmlt.feedback.BMLTSchedulingFinishedFeedback;
import hmi.bml.ext.bmlt.feedback.BMLTSchedulingListener;
import hmi.bml.ext.bmlt.feedback.BMLTSchedulingStartFeedback;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLPerformanceStartFeedback;
import hmi.bml.feedback.BMLPerformanceStopFeedback;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.bml.feedback.BMLWarningFeedback;
import hmi.bml.feedback.BMLWarningListener;
import hmi.bml.parser.BMLParser;
import hmi.elckerlyc.BehaviorNotFoundException;
import hmi.elckerlyc.Engine;
import hmi.elckerlyc.SyncPointNotFoundException;
import hmi.elckerlyc.TimePegAlreadySetException;
import hmi.elckerlyc.anticipator.Anticipator;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.pegboard.BMLBlockPeg;
import hmi.elckerlyc.pegboard.PegBoard;
import hmi.elckerlyc.pegboard.TimePeg;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.scheduler.BMLBlock;
import hmi.elckerlyc.scheduler.BMLBlockManager;
import hmi.elckerlyc.scheduler.SchedulingHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BMLScheduler {
    private final Logger logger = LoggerFactory.getLogger((String)BMLScheduler.class.getName());
    private final BMLParser parser;
    private final BMLBlockManager bmlBlocksManager;
    private final Map<Class<? extends Behaviour>, Engine> planSelector;
    private final Map<String, Anticipator> anticipators;
    private final PegBoard pegBoard;
    private final SchedulingClock schedulingClock;
    private final SchedulingHandler schedulingHandler;
    private final FeedbackManager fbManager;

    public double getSchedulingTime() {
        return this.schedulingClock.getTime();
    }

    public BMLScheduler(String characterId, BMLParser s, FeedbackManager bfm, SchedulingClock c, SchedulingHandler sh, BMLBlockManager bbm, PegBoard pb) {
        this.fbManager = bfm;
        this.parser = s;
        this.schedulingClock = c;
        this.schedulingHandler = sh;
        this.pegBoard = pb;
        this.planSelector = new HashMap<Class<? extends Behaviour>, Engine>();
        this.anticipators = new HashMap<String, Anticipator>();
        this.bmlBlocksManager = bbm;
    }

    public double getRigidity(Behaviour beh) {
        Engine e = this.planSelector.get(beh.getClass());
        if (e == null) {
            return 0.0;
        }
        return e.getRigidity(beh);
    }

    public Set<String> getTimedSyncs(String bmlId, String behId) {
        return this.pegBoard.getTimedSyncs(bmlId, behId);
    }

    public TimePeg getTimePeg(String bmlId, String behId, String syncId) throws BehaviorNotFoundException, SyncPointNotFoundException, TimePegAlreadySetException {
        TimePeg tp = this.pegBoard.getTimePeg(bmlId, behId, syncId);
        if (tp == null) {
            for (Engine e : this.getEngines()) {
                if (!e.containsBehaviour(bmlId, behId)) continue;
                tp = e.createOffsetPeg(bmlId, behId, syncId);
                break;
            }
        }
        return tp;
    }

    public void setParameterValue(String bmlId, String behId, String paramId, float value) throws ParameterException, BehaviorNotFoundException {
        boolean found = false;
        for (Engine e : this.getEngines()) {
            if (!e.containsBehaviour(bmlId, behId)) continue;
            e.setFloatParameterValue(bmlId, behId, paramId, value);
            found = true;
        }
        if (!found) {
            throw new BehaviorNotFoundException(bmlId, behId);
        }
    }

    public void setParameterValue(String bmlId, String behId, String paramId, String value) throws ParameterException, BehaviorNotFoundException {
        boolean found = false;
        for (Engine e : this.getEngines()) {
            if (!e.containsBehaviour(bmlId, behId)) continue;
            e.setParameterValue(bmlId, behId, paramId, value);
            found = true;
        }
        if (!found) {
            throw new BehaviorNotFoundException(bmlId, behId);
        }
    }

    public float getFloatParameterValue(String bmlId, String behId, String paramId) throws ParameterException, BehaviorNotFoundException {
        for (Engine e : this.getEngines()) {
            if (!e.containsBehaviour(bmlId, behId)) continue;
            return e.getFloatParameterValue(bmlId, behId, paramId);
        }
        throw new BehaviorNotFoundException(bmlId, behId);
    }

    public String getParameterValue(String bmlId, String behId, String paramId) throws ParameterException, BehaviorNotFoundException {
        for (Engine e : this.getEngines()) {
            if (!e.containsBehaviour(bmlId, behId)) continue;
            return e.getParameterValue(bmlId, behId, paramId);
        }
        throw new BehaviorNotFoundException(bmlId, behId);
    }

    public List<Engine> getEngines() {
        ArrayList<Engine> engines = new ArrayList<Engine>();
        for (Engine e : this.planSelector.values()) {
            if (engines.contains(e)) continue;
            engines.add(e);
        }
        return engines;
    }

    public void addBMLBlock(BMLBlock bbm) {
        this.bmlBlocksManager.addBMLBlock(bbm);
    }

    public Set<String> getBMLBlocks() {
        return this.bmlBlocksManager.getBMLBlocks();
    }

    public void updateBMLBlocks() {
        this.bmlBlocksManager.updateBlocks();
    }

    public void reset() {
        List<Engine> engines = this.getEngines();
        for (Engine e : engines) {
            e.reset(this.schedulingClock.getTime());
        }
        this.bmlBlocksManager.updateBlocks();
        this.bmlBlocksManager.clear();
        this.pegBoard.clear();
    }

    public void shutdown() {
        List<Engine> engines = this.getEngines();
        for (Engine e : engines) {
            e.shutdown();
        }
    }

    public void addEngine(Class<? extends Behaviour> c, Engine e) {
        this.planSelector.put(c, e);
    }

    public void addAnticipator(String id, Anticipator ap) {
        this.anticipators.put(id, ap);
    }

    public void removeAnticipator(String aid) {
        this.anticipators.remove(aid);
    }

    public int getNumberOfAnticipators() {
        return this.anticipators.values().size();
    }

    public void planningStart(String bmlId, double predictedStart) {
        this.planningStart(new BMLTSchedulingStartFeedback("ps-" + bmlId, bmlId, this.schedulingClock.getTime(), predictedStart));
    }

    public void planningFinished(String bmlId, double predictedStart, double predictedEnd) {
        this.planningFinished(new BMLTSchedulingFinishedFeedback("ps-" + bmlId, bmlId, this.schedulingClock.getTime(), predictedStart, predictedEnd));
    }

    public void blockStopFeedback(String bmlId) {
        BMLPerformanceStopFeedback psf = new BMLPerformanceStopFeedback(bmlId, "", this.schedulingClock.getTime());
        this.fbManager.blockStopFeedback(psf);
    }

    public void blockStartFeedback(String bmlId) {
        BMLPerformanceStartFeedback psf = new BMLPerformanceStartFeedback(bmlId, this.schedulingClock.getTime(), this.predictEndTime(bmlId));
        this.fbManager.blockStartFeedback(psf);
    }

    public Engine getEngine(Class<? extends Behaviour> c) {
        return this.planSelector.get(c);
    }

    public void removeBehaviour(String bmlId, String behaviourId) {
        for (Engine e : this.getEngines()) {
            e.interruptBehaviour(bmlId, behaviourId, this.schedulingClock.getTime());
        }
        this.pegBoard.removeBehaviour(bmlId, behaviourId);
    }

    public double getEndTime(String bmlId, String behId) {
        for (Engine e : this.getEngines()) {
            double endTime = e.getEndTime(bmlId, behId);
            if (endTime == -1.7976931348623157E308) continue;
            return endTime;
        }
        return -1.7976931348623157E308;
    }

    public Set<String> getBehaviours(String bmlId) {
        HashSet<String> behaviours = new HashSet<String>();
        for (Engine e : this.getEngines()) {
            behaviours.addAll(e.getBehaviours(bmlId));
        }
        return behaviours;
    }

    public double predictSubsidingTime(String bmlId) {
        ArrayList<Double> subsidingTimes = new ArrayList<Double>();
        subsidingTimes.add(this.schedulingClock.getTime());
        for (Engine e : this.getEngines()) {
            subsidingTimes.add(e.getBlockSubsidingTime(bmlId));
        }
        return (Double)Collections.max(subsidingTimes);
    }

    public double predictSubsidingTime(Set<String> bmlIds) {
        ArrayList<Double> subsidingTimes = new ArrayList<Double>();
        subsidingTimes.add(this.schedulingClock.getTime());
        for (String bmlId : bmlIds) {
            subsidingTimes.add(this.predictSubsidingTime(bmlId));
        }
        return (Double)Collections.max(subsidingTimes);
    }

    public double predictEndTime(Set<String> bmlIds) {
        ArrayList<Double> endTimes = new ArrayList<Double>();
        endTimes.add(this.schedulingClock.getTime());
        for (String bmlId : bmlIds) {
            endTimes.add(this.predictEndTime(bmlId));
        }
        return (Double)Collections.max(endTimes);
    }

    public double predictEndTime(String blockId) {
        ArrayList<Double> endTimes = new ArrayList<Double>();
        endTimes.add(this.schedulingClock.getTime());
        for (Engine e : this.getEngines()) {
            endTimes.add(e.getBlockEndTime(blockId));
        }
        return (Double)Collections.max(endTimes);
    }

    public void schedule() {
        for (BehaviourBlock bb : this.parser.getBehaviourBlocks()) {
            this.schedulingHandler.schedule(bb, this);
        }
        this.parser.clear();
    }

    public void interruptBehavior(String bmlId, String behaviourId) {
        for (Engine e : this.getEngines()) {
            e.interruptBehaviour(bmlId, behaviourId, this.schedulingClock.getTime());
        }
        this.bmlBlocksManager.updateBlocks();
    }

    public void interruptBlock(String bmlId) {
        if (!this.bmlBlocksManager.getBMLBlocks().contains(bmlId)) {
            this.logger.warn("Attempting to stop non existing bml block {}", (Object)bmlId);
            return;
        }
        for (Engine e : this.getEngines()) {
            e.interruptBehaviourBlock(bmlId, this.schedulingClock.getTime());
        }
        if (this.bmlBlocksManager.getBMLBlockState(bmlId) == TimedPlanUnitState.IN_EXEC || this.bmlBlocksManager.getBMLBlockState(bmlId) == TimedPlanUnitState.SUBSIDING) {
            this.bmlBlocksManager.finishBlock(bmlId);
        }
        this.bmlBlocksManager.removeBMLBlock(bmlId);
    }

    public void activateBlock(String bmlId) {
        this.bmlBlocksManager.activateBlock(bmlId);
    }

    public void addBMLBlockPeg(BMLBlockPeg peg) {
        this.pegBoard.addBMLBlockPeg(peg);
    }

    public void startBlock(String bmlId) {
        if (!this.bmlBlocksManager.getBMLBlocks().contains(bmlId)) {
            this.logger.warn("Attempting to start non existing bml block {}", (Object)bmlId);
            return;
        }
        this.pegBoard.setBMLBlockTime(bmlId, this.schedulingClock.getTime());
        this.logger.debug("Starting bml block {}", (Object)bmlId);
        this.bmlBlocksManager.startBlock(bmlId);
        for (Engine e : this.getEngines()) {
            e.setBMLBlockState(bmlId, TimedPlanUnitState.LURKING);
        }
        this.bmlBlocksManager.updateBlocks();
    }

    public void activateBlock(String bmlId, double time) {
        this.bmlBlocksManager.activateBlock(bmlId);
    }

    public Anticipator getAnticipator(String a) {
        return this.anticipators.get(a);
    }

    public BMLParser getParser() {
        return this.parser;
    }

    public void removeInvalidBehaviors(String bmlBlock) {
        for (Engine e : this.getEngines()) {
            this.logger.debug("Checking behavior validity for engine {}", e.getClass());
            Set<String> invalidBehaviours = e.getInvalidBehaviours();
            for (String id : invalidBehaviours) {
                String bmlId = id.split(":")[0];
                if (!bmlId.equals(bmlBlock)) continue;
                String behId = id.substring(bmlId.length() + 1);
                HashSet<String> droppedBehaviours = new HashSet<String>();
                droppedBehaviours.add(behId);
                HashSet modifiedConstraints = new HashSet();
                String warningText = "Invalid timing for behavior " + id + ", behavior ommitted";
                this.exception(new BMLExceptionFeedback(bmlId, this.schedulingClock.getTime(), droppedBehaviours, modifiedConstraints, warningText, false));
                this.removeBehaviour(bmlId, behId);
            }
        }
    }

    public void removeInvalidBehaviors() {
        this.logger.debug("Checking behavior validity");
        for (Engine e : this.getEngines()) {
            this.logger.debug("Checking behavior validity for engine {}", e.getClass());
            Set<String> invalidBehaviours = e.getInvalidBehaviours();
            for (String id : invalidBehaviours) {
                String bmlId = id.split(":")[0];
                String behId = id.substring(bmlId.length() + 1);
                HashSet<String> droppedBehaviours = new HashSet<String>();
                droppedBehaviours.add(behId);
                HashSet modifiedConstraints = new HashSet();
                String warningText = "Invalid timing for behavior " + id + ", behavior ommitted";
                this.exception(new BMLExceptionFeedback(bmlId, this.schedulingClock.getTime(), droppedBehaviours, modifiedConstraints, warningText, false));
                this.removeBehaviour(bmlId, behId);
            }
        }
    }

    public ImmutableSet<BMLSyncPointProgressFeedback> getSyncProgress(String bmlId, String behaviorId) {
        return this.bmlBlocksManager.getSyncProgress(bmlId, behaviorId);
    }

    public ImmutableSet<String> getSyncsPassed(String bmlId, String behaviorId) {
        return this.bmlBlocksManager.getSyncsPassed(bmlId, behaviorId);
    }

    public TimedPlanUnitState getBMLBlockState(String bmlId) {
        return this.bmlBlocksManager.getBMLBlockState(bmlId);
    }

    public BMLBlockManager getBMLBlockManager() {
        return this.bmlBlocksManager;
    }

    public void addWarningListener(BMLWarningListener ws) {
        this.fbManager.addWarningListener(ws);
    }

    public void removeWarningListener(BMLWarningListener ws) {
        this.fbManager.removeWarningListener(ws);
    }

    public void removeAllWarningListeners() {
        this.fbManager.removeAllWarningListeners();
    }

    public void removeAllExceptionListeners() {
        this.fbManager.removeAllExceptionListeners();
    }

    public void addExceptionListener(BMLExceptionListener e) {
        this.fbManager.addExceptionListener(e);
    }

    public void removeExceptionListener(BMLExceptionListener e) {
        this.fbManager.removeExceptionListener(e);
    }

    public void addPlanningListener(BMLTSchedulingListener p) {
        this.fbManager.addPlanningListener(p);
    }

    public void removeAllPlanningListeners() {
        this.fbManager.removeAllPlanningListeners();
    }

    public void warn(BMLWarningFeedback w) {
        this.fbManager.warn(w);
    }

    public void planningStart(BMLTSchedulingStartFeedback bpsf) {
        this.fbManager.planningStart(bpsf);
    }

    public void planningFinished(BMLTSchedulingFinishedFeedback bpff) {
        this.fbManager.planningFinished(bpff);
    }

    public void exception(BMLExceptionFeedback e) {
        this.fbManager.exception(e);
    }

    public void addFeedbackListener(BMLFeedbackListener e) {
        this.fbManager.addFeedbackListener(e);
    }

    public void removeFeedbackListener(BMLFeedbackListener e) {
        this.fbManager.removeFeedbackListener(e);
    }

    public void removeAllFeedbackListeners() {
        this.fbManager.removeAllFeedbackListeners();
    }

    private static interface FeedbackManagerDelegates {
        public void addWarningListener(BMLWarningListener var1);

        public void removeWarningListener(BMLWarningListener var1);

        public void removeAllWarningListeners();

        public void removeAllExceptionListeners();

        public void addExceptionListener(BMLExceptionListener var1);

        public void removeExceptionListener(BMLExceptionListener var1);

        public void addPlanningListener(BMLTSchedulingListener var1);

        public void removeAllPlanningListeners();

        public void warn(BMLWarningFeedback var1);

        public void planningStart(BMLTSchedulingStartFeedback var1);

        public void planningFinished(BMLTSchedulingFinishedFeedback var1);

        public void exception(BMLExceptionFeedback var1);

        public void addFeedbackListener(BMLFeedbackListener var1);

        public void removeFeedbackListener(BMLFeedbackListener var1);

        public void removeAllFeedbackListeners();
    }
}

