/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.scheduler;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLPerformanceStartFeedback;
import hmi.bml.feedback.BMLPerformanceStopFeedback;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.bml.feedback.BMLWarningFeedback;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.scheduler.BMLBlock;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BMLBlockManager {
    private final ConcurrentHashMap<String, BMLBlock> finishedBMLBlocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, BMLBlock> BMLBlocks = new ConcurrentHashMap();
    private final Logger logger = LoggerFactory.getLogger((String)BMLBlockManager.class.getName());
    private final SetMultimap<BehaviorKey, BMLSyncPointProgressFeedback> behaviorProgress;

    public BMLBlockManager() {
        HashMultimap behaviorProgressMap = HashMultimap.create();
        this.behaviorProgress = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create((Multimap)behaviorProgressMap));
    }

    public synchronized void addBMLBlock(BMLBlock bbm) {
        this.BMLBlocks.put(bbm.getBMLId(), bbm);
    }

    public synchronized void removeBMLBlock(String bmlId) {
        this.BMLBlocks.remove(bmlId);
        this.finishedBMLBlocks.remove(bmlId);
        this.updateBlocks();
    }

    public void finishBlock(String bmlId) {
        BMLBlock b = this.BMLBlocks.get(bmlId);
        if (b != null) {
            b.finish();
        }
    }

    public synchronized void startBlock(String bmlId) {
        BMLBlock b = this.BMLBlocks.get(bmlId);
        if (b != null) {
            b.start();
        }
    }

    public synchronized TimedPlanUnitState getBMLBlockState(String bmlId) {
        BMLBlock b = this.BMLBlocks.get(bmlId);
        if (b == null) {
            return TimedPlanUnitState.DONE;
        }
        return b.getState();
    }

    public synchronized Set<String> getBMLBlocks() {
        HashSet<String> bmlBlocks = new HashSet<String>();
        for (String bmlId : this.BMLBlocks.keySet()) {
            bmlBlocks.add(bmlId);
        }
        return bmlBlocks;
    }

    private ImmutableMap<String, TimedPlanUnitState> getBlockStates() {
        HashMap<String, TimedPlanUnitState> blockStates = new HashMap<String, TimedPlanUnitState>();
        for (BMLBlock block : this.BMLBlocks.values()) {
            blockStates.put(block.getBMLId(), block.getState());
        }
        return ImmutableMap.copyOf(blockStates);
    }

    public synchronized void updateBlocks() {
        ImmutableMap<String, TimedPlanUnitState> m = this.getBlockStates();
        for (BMLBlock block : this.BMLBlocks.values()) {
            block.update(m);
        }
    }

    public synchronized void clear() {
        this.finishedBMLBlocks.clear();
        this.BMLBlocks.clear();
        this.behaviorProgress.clear();
    }

    public synchronized void activateBlock(String bmlId) {
        BMLBlock bb = this.BMLBlocks.get(bmlId);
        if (bb == null) {
            this.logger.warn("Attempting to activate unknown block {}", (Object)bmlId);
            return;
        }
        bb.activate();
        this.updateBlocks();
    }

    public synchronized void performanceStop(BMLPerformanceStopFeedback psf) {
        BMLBlock block = this.BMLBlocks.get(psf.bmlId);
        if (block == null) {
            this.logger.warn("Performance stop of block " + psf.bmlId + " not managed by the BMLBlockManager");
            return;
        }
        this.updateBlocks();
    }

    public synchronized void performanceStart(BMLPerformanceStartFeedback psf) {
        this.updateBlocks();
    }

    public synchronized void warn(BMLWarningFeedback bw) {
        this.updateBlocks();
    }

    public synchronized void exception(BMLExceptionFeedback be) {
        for (BMLBlock block : this.BMLBlocks.values()) {
            if (!block.getBMLId().equals(be.bmlId)) continue;
            block.dropBehaviours(be.failedBehaviours);
        }
        this.updateBlocks();
    }

    public synchronized void syncProgress(BMLSyncPointProgressFeedback spp) {
        this.behaviorProgress.put((Object)new BehaviorKey(spp.bmlId, spp.behaviorId), (Object)spp);
        this.logger.debug("Adding sync {}:{}:{} to behaviorProgress", (Object[])new String[]{spp.bmlId, spp.behaviorId, spp.syncId});
        for (BMLBlock block : this.BMLBlocks.values()) {
            if (!block.getBMLId().equals(spp.bmlId)) continue;
            block.behaviorProgress(spp.behaviorId, spp.syncId);
        }
        this.updateBlocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSet<BMLSyncPointProgressFeedback> getSyncProgress(String bmlId, String behaviorId) {
        SetMultimap<BehaviorKey, BMLSyncPointProgressFeedback> setMultimap = this.behaviorProgress;
        synchronized (setMultimap) {
            return ImmutableSet.copyOf((Collection)this.behaviorProgress.get((Object)new BehaviorKey(bmlId, behaviorId)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSet<String> getSyncsPassed(String bmlId, String behaviorId) {
        HashSet<String> progress = new HashSet<String>();
        SetMultimap<BehaviorKey, BMLSyncPointProgressFeedback> setMultimap = this.behaviorProgress;
        synchronized (setMultimap) {
            Set sppf = this.behaviorProgress.get((Object)new BehaviorKey(bmlId, behaviorId));
            for (BMLSyncPointProgressFeedback spp : sppf) {
                progress.add(spp.syncId);
            }
        }
        return ImmutableSet.copyOf(progress);
    }

    private static class BehaviorKey {
        final String id;
        final String bmlId;

        public BehaviorKey(String bmlId, String id) {
            this.id = id;
            this.bmlId = bmlId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BehaviorKey)) {
                return false;
            }
            BehaviorKey pk = (BehaviorKey)o;
            return pk.bmlId.equals(this.bmlId) && pk.id.equals(this.id);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.id, this.bmlId});
        }
    }
}

