/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.scheduler;

import hmi.bml.BMLGestureSync;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.scheduler.BMLBlock;
import hmi.elckerlyc.scheduler.BMLScheduler;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBMLBlock
implements BMLBlock {
    protected final String bmlId;
    protected final BMLScheduler scheduler;
    protected AtomicReference<TimedPlanUnitState> state = new AtomicReference();
    private static final Logger logger = LoggerFactory.getLogger((String)AbstractBMLBlock.class.getName());
    protected final ConcurrentHashMap<String, Set<String>> behaviorSyncsPassed = new ConcurrentHashMap();
    protected final Set<String> droppedBehaviours = new CopyOnWriteArraySet<String>();

    public AbstractBMLBlock(String id, BMLScheduler s) {
        this.bmlId = id;
        this.scheduler = s;
        this.state.set(TimedPlanUnitState.IN_PREP);
    }

    @Override
    public void start() {
        this.state.set(TimedPlanUnitState.IN_EXEC);
        this.scheduler.blockStartFeedback(this.bmlId);
    }

    @Override
    public void activate() {
        this.state.set(TimedPlanUnitState.LURKING);
    }

    @Override
    public void finish() {
        this.state.set(TimedPlanUnitState.DONE);
        this.scheduler.blockStopFeedback(this.bmlId);
    }

    protected boolean isFinished() {
        for (String behId : this.scheduler.getBehaviours(this.bmlId)) {
            if (this.droppedBehaviours.contains(behId)) continue;
            logger.debug("checking isFinished {}:{}", (Object)this.bmlId, (Object)behId);
            Set<String> finishedInfo = this.behaviorSyncsPassed.get(behId);
            if (finishedInfo == null) {
                return false;
            }
            if (finishedInfo.contains(BMLGestureSync.END.getId())) continue;
            return false;
        }
        return true;
    }

    protected boolean isSubsiding() {
        for (String behId : this.scheduler.getBehaviours(this.bmlId)) {
            if (this.droppedBehaviours.contains(behId)) continue;
            Set<String> finishedInfo = this.behaviorSyncsPassed.get(behId);
            if (finishedInfo == null) {
                return false;
            }
            if (finishedInfo.contains(BMLGestureSync.RELAX.getId()) || finishedInfo.contains("end")) continue;
            return false;
        }
        logger.debug("{} is subsiding at {}", (Object)this.bmlId, (Object)this.scheduler.getSchedulingTime());
        return true;
    }

    @Override
    public void setState(TimedPlanUnitState state) {
        this.state.set(state);
    }

    @Override
    public TimedPlanUnitState getState() {
        return this.state.get();
    }

    @Override
    public void dropBehaviours(Set<String> behs) {
        this.droppedBehaviours.addAll(behs);
    }

    @Override
    public String getBMLId() {
        return this.bmlId;
    }

    @Override
    public void behaviorProgress(String behaviorId, String syncId) {
        Set<String> behInfo = this.behaviorSyncsPassed.get(behaviorId);
        if (behInfo == null) {
            behInfo = new HashSet<String>();
            this.behaviorSyncsPassed.put(behaviorId, behInfo);
        }
        behInfo.add(syncId);
    }
}

