/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import com.google.common.collect.ImmutableList;
import hmi.elckerlyc.BehaviorNotFoundException;
import hmi.elckerlyc.SyncPointNotFoundException;
import hmi.elckerlyc.TimePegAlreadySetException;
import hmi.elckerlyc.pegboard.OffsetPeg;
import hmi.elckerlyc.pegboard.TimePeg;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.PlanUnitTimeManager;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitPlayException;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PlanManager<T extends TimedPlanUnit> {
    @GuardedBy(value="planUnits")
    private List<T> planUnits = new ArrayList<T>();
    private static final Logger logger = LoggerFactory.getLogger((String)PlanUnitTimeManager.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<T> getPlanUnits() {
        ImmutableList l;
        List<T> list = this.planUnits;
        synchronized (list) {
            l = new ImmutableList.Builder().addAll(this.planUnits).build();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getInvalidBehaviours() {
        HashSet<String> invalidBehaviours = new HashSet<String>();
        List<T> list = this.planUnits;
        synchronized (list) {
            for (TimedPlanUnit pu : this.planUnits) {
                if (pu.hasValidTiming()) continue;
                invalidBehaviours.add(pu.getBMLId() + ":" + pu.getId());
            }
        }
        return invalidBehaviours;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlanUnits(Collection<T> pus) {
        List<T> list = this.planUnits;
        synchronized (list) {
            this.planUnits.addAll(pus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlanUnit(T pu) {
        List<T> list = this.planUnits;
        synchronized (list) {
            this.planUnits.add(pu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlanUnits(Collection<T> puRemove, double time) {
        List<T> list = this.planUnits;
        synchronized (list) {
            this.planUnits.removeAll(puRemove);
        }
        for (TimedPlanUnit pu : puRemove) {
            logger.debug("Removing planunit {}:{}", (Object)pu.getBMLId(), (Object)pu.getId());
            if (!pu.isPlaying()) continue;
            try {
                pu.stop(time);
            }
            catch (TimedPlanUnitPlayException e) {
                logger.warn("Exception stopping behaviour: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getPlanUnit(String bmlId, String id) {
        List<T> list = this.planUnits;
        synchronized (list) {
            for (TimedPlanUnit pu : this.planUnits) {
                if (!pu.getId().equals(id) || !pu.getBMLId().equals(bmlId)) continue;
                return (T)pu;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptPlanUnit(String bmlId, String id, double globalTime) {
        ArrayList<T> planUnitsToInterrupt = new ArrayList<T>();
        List<T> list = this.planUnits;
        synchronized (list) {
            Object pu = this.getPlanUnit(bmlId, id);
            while (pu != null) {
                planUnitsToInterrupt.add(pu);
                this.planUnits.remove(pu);
                pu = this.getPlanUnit(bmlId, id);
            }
        }
        for (Object pu : planUnitsToInterrupt) {
            if (!pu.isPlaying()) continue;
            try {
                pu.stop(globalTime);
            }
            catch (TimedPlanUnitPlayException e) {
                logger.warn("Exception stopping behaviour: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfPlanUnits() {
        List<T> list = this.planUnits;
        synchronized (list) {
            return this.planUnits.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBMLBlockState(String bmlId, TimedPlanUnitState state) {
        List<T> list = this.planUnits;
        synchronized (list) {
            for (TimedPlanUnit pu : this.planUnits) {
                if (!pu.getBMLId().equals(bmlId)) continue;
                logger.debug("Setting BML {} block state of {}:{} to {}.", (Object[])new String[]{pu.isSubUnit() ? "sub" : "", pu.getBMLId(), pu.getId(), state.toString()});
                pu.setState(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllPlanUnits(double time) {
        ImmutableList copyOfPlanUnits;
        List<T> list = this.planUnits;
        synchronized (list) {
            copyOfPlanUnits = ImmutableList.copyOf(this.planUnits);
        }
        this.removePlanUnits((Collection<T>)copyOfPlanUnits, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFinishedPlanUnits() {
        List<T> list = this.planUnits;
        synchronized (list) {
            ArrayList<TimedPlanUnit> finishedUnits = new ArrayList<TimedPlanUnit>();
            for (TimedPlanUnit pu : this.planUnits) {
                if (!pu.isDone()) continue;
                finishedUnits.add(pu);
            }
            this.planUnits.removeAll(finishedUnits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsBehaviour(String bmlId, String behId) {
        List<T> list = this.planUnits;
        synchronized (list) {
            for (TimedPlanUnit pu : this.planUnits) {
                if (!pu.getBMLId().equals(bmlId) || !pu.getId().equals(behId) || pu.isSubUnit()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getBehaviours(String bmlId) {
        HashSet<String> behaviours = new HashSet<String>();
        List<T> list = this.planUnits;
        synchronized (list) {
            for (TimedPlanUnit pu : this.planUnits) {
                if (!pu.getBMLId().equals(bmlId)) continue;
                behaviours.add(pu.getId());
            }
        }
        return behaviours;
    }

    private double getLastSetTime(T pu) {
        double endTime = 0.0;
        if (pu.getEndTime() != -1.7976931348623157E308) {
            return pu.getEndTime();
        }
        for (String syncId : pu.getAvailableSyncs()) {
            if (pu.getTime(syncId) == -1.7976931348623157E308) continue;
            endTime = pu.getTime(syncId);
        }
        return endTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSubsidingTime(String bmlId) {
        double subsidingTime = 0.0;
        List<T> list = this.planUnits;
        synchronized (list) {
            for (TimedPlanUnit pu : this.planUnits) {
                if (!pu.getBMLId().equals(bmlId) || pu.getRelaxTime() == -1.7976931348623157E308 || !(pu.getRelaxTime() > subsidingTime)) continue;
                subsidingTime = pu.getRelaxTime();
            }
        }
        return subsidingTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getEndTime(String bmlId) {
        double endTime = 0.0;
        List<T> list = this.planUnits;
        synchronized (list) {
            for (TimedPlanUnit pu : this.planUnits) {
                double lastTime;
                if (!pu.getBMLId().equals(bmlId) || !((lastTime = this.getLastSetTime(pu)) > endTime)) continue;
                endTime = lastTime;
            }
        }
        return endTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getEndTime(String bmlId, String behId) {
        List<T> list = this.planUnits;
        synchronized (list) {
            T pu = this.getPlanUnit(bmlId, behId);
            if (pu == null || pu.isSubUnit()) {
                return -1.7976931348623157E308;
            }
            return pu.getEndTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptBehaviourBlock(String bmlId, double time) {
        ArrayList<TimedPlanUnit> removeUnits = new ArrayList<TimedPlanUnit>();
        List<T> list = this.planUnits;
        synchronized (list) {
            for (TimedPlanUnit pu : this.planUnits) {
                if (!pu.getBMLId().equals(bmlId)) continue;
                removeUnits.add(pu);
            }
        }
        this.removePlanUnits(removeUnits, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFloatParameterValue(String bmlId, String behId, String paramId, float value) throws ParameterException, BehaviorNotFoundException {
        boolean found = false;
        logger.debug("setFloatParameterValue parameter:{} value:{}", (Object)paramId, (Object)Float.valueOf(value));
        List<T> list = this.planUnits;
        synchronized (list) {
            logger.debug("setFloatParameterValue in sync");
            for (TimedPlanUnit pu : this.planUnits) {
                if (!pu.getBMLId().equals(bmlId) || !pu.getId().equals(behId)) continue;
                pu.setFloatParameterValue(paramId, value);
                found = true;
            }
            logger.debug("setFloatParameterValue done");
        }
        if (!found) {
            throw new BehaviorNotFoundException(bmlId, behId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffsetPeg createOffsetPeg(String bmlId, String behId, String syncId) throws BehaviorNotFoundException, SyncPointNotFoundException, TimePegAlreadySetException {
        List<T> list = this.planUnits;
        synchronized (list) {
            TimePeg link;
            T pu = this.getPlanUnit(bmlId, behId);
            if (pu == null) {
                throw new BehaviorNotFoundException(bmlId, behId);
            }
            if (pu.getTime(syncId) != -1.7976931348623157E308) {
                throw new TimePegAlreadySetException(bmlId, behId, syncId);
            }
            double relTime = pu.getRelativeTime(syncId);
            String tpBefore = null;
            String tpAfter = null;
            boolean before = true;
            for (String sync : pu.getAvailableSyncs()) {
                if (sync.equals(syncId)) {
                    before = false;
                    continue;
                }
                if (pu.getTime(sync) == -1.7976931348623157E308) continue;
                if (before) {
                    tpBefore = sync;
                    continue;
                }
                tpAfter = sync;
                break;
            }
            if (tpBefore == null && tpAfter == null) {
                throw new AssertionError((Object)"TimedPlanUnit with no set syncpoints!");
            }
            double globalDuration = 0.0;
            double relativeDuration = 0.0;
            double offset = 0.0;
            if (tpBefore != null && tpAfter != null) {
                globalDuration = pu.getTime(tpAfter) - pu.getTime(tpBefore);
                relativeDuration = pu.getRelativeTime(tpAfter) - pu.getRelativeTime(tpBefore);
            }
            if (tpBefore == null) {
                link = pu.getTimePeg(tpAfter);
            } else if (tpAfter == null) {
                link = pu.getTimePeg(tpBefore);
            } else if (relTime - pu.getRelativeTime(tpBefore) < pu.getRelativeTime(tpAfter) - relTime) {
                link = pu.getTimePeg(tpBefore);
                offset = globalDuration * ((relTime - pu.getRelativeTime(tpBefore)) / relativeDuration);
            } else {
                link = pu.getTimePeg(tpAfter);
                offset = globalDuration * ((relTime - pu.getRelativeTime(tpAfter)) / relativeDuration);
            }
            return new OffsetPeg(link, offset, pu.getBMLBlockPeg());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterValue(String bmlId, String behId, String paramId, String value) throws ParameterException, BehaviorNotFoundException {
        boolean found = false;
        List<T> list = this.planUnits;
        synchronized (list) {
            for (TimedPlanUnit pu : this.planUnits) {
                if (!pu.getBMLId().equals(bmlId) || !pu.getId().equals(behId)) continue;
                pu.setParameterValue(paramId, value);
                found = true;
            }
        }
        if (!found) {
            throw new BehaviorNotFoundException(bmlId, behId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloatParameterValue(String bmlId, String behId, String paramId) throws ParameterException, BehaviorNotFoundException {
        List<T> list = this.planUnits;
        synchronized (list) {
            for (TimedPlanUnit pu : this.planUnits) {
                if (!pu.getBMLId().equals(bmlId) || !pu.getId().equals(behId) || pu.isSubUnit()) continue;
                return pu.getFloatParameterValue(paramId);
            }
        }
        throw new BehaviorNotFoundException(bmlId, behId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameterValue(String bmlId, String behId, String paramId) throws ParameterException, BehaviorNotFoundException {
        List<T> list = this.planUnits;
        synchronized (list) {
            for (TimedPlanUnit pu : this.planUnits) {
                if (!pu.getBMLId().equals(bmlId) || !pu.getId().equals(behId) || pu.isSubUnit()) continue;
                return pu.getParameterValue(paramId);
            }
        }
        throw new BehaviorNotFoundException(bmlId, behId);
    }
}

