/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import hmi.elckerlyc.planunit.AbstractTimedPlanUnitPlayer;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitPlayException;
import hmi.util.RuntimeExceptionLoggingRunnable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MultiThreadedTimedPlanUnitPlayer
extends AbstractTimedPlanUnitPlayer {
    private static final int NUM_THREADS = 25;
    private Map<TimedPlanUnit, CountDownLatch> playMap = new HashMap<TimedPlanUnit, CountDownLatch>();
    private final ExecutorService exec = Executors.newFixedThreadPool(25);

    public MultiThreadedTimedPlanUnitPlayer() {
        this.playExceptions = Collections.synchronizedList(new ArrayList());
        this.stopExceptions = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public void playUnit(TimedPlanUnit su, double t) {
        CountDownLatch prevLatch = this.playMap.get(su);
        CountDownLatch curLatch = new CountDownLatch(1);
        this.playMap.put(su, curLatch);
        this.exec.submit((Runnable)new RuntimeExceptionLoggingRunnable((Runnable)new TPUPlayRunner(su, t, prevLatch, curLatch)));
    }

    @Override
    public void stopUnit(TimedPlanUnit su, double t) {
        CountDownLatch prevLatch = this.playMap.get(su);
        CountDownLatch curLatch = new CountDownLatch(1);
        this.playMap.put(su, curLatch);
        this.exec.submit((Runnable)new RuntimeExceptionLoggingRunnable((Runnable)new TPUStopRunner(su, t, prevLatch, curLatch)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableCollection<TimedPlanUnitPlayException> getPlayExceptions() {
        ImmutableList ex;
        List list = this.playExceptions;
        synchronized (list) {
            ex = new ImmutableList.Builder().addAll((Iterable)this.playExceptions).build();
        }
        return ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableCollection<TimedPlanUnitPlayException> getStopExceptions() {
        ImmutableList ex;
        List list = this.stopExceptions;
        synchronized (list) {
            ex = new ImmutableList.Builder().addAll((Iterable)this.stopExceptions).build();
        }
        return ex;
    }

    class TPUPlayRunner
    implements Runnable {
        private final double time;
        private final TimedPlanUnit tpu;
        private final CountDownLatch prevLatch;
        private final CountDownLatch curLatch;

        public TPUPlayRunner(TimedPlanUnit tpu, double t, CountDownLatch prev, CountDownLatch cur) {
            this.tpu = tpu;
            this.time = t;
            this.prevLatch = prev;
            this.curLatch = cur;
        }

        @Override
        public void run() {
            if (this.prevLatch != null) {
                try {
                    this.prevLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            try {
                if (this.tpu.getState().isLurking()) {
                    this.tpu.start(this.time);
                }
                this.tpu.play(this.time);
            }
            catch (TimedPlanUnitPlayException e) {
                MultiThreadedTimedPlanUnitPlayer.this.playExceptions.add(e);
            }
            this.curLatch.countDown();
        }
    }

    class TPUStopRunner
    implements Runnable {
        private final double time;
        private final TimedPlanUnit tpu;
        private final CountDownLatch prevLatch;
        private final CountDownLatch curLatch;

        public TPUStopRunner(TimedPlanUnit tpu, double t, CountDownLatch prev, CountDownLatch cur) {
            this.tpu = tpu;
            this.time = t;
            this.prevLatch = prev;
            this.curLatch = cur;
        }

        @Override
        public void run() {
            if (this.prevLatch != null) {
                try {
                    this.prevLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            try {
                this.tpu.stop(this.time);
            }
            catch (TimedPlanUnitPlayException e) {
                MultiThreadedTimedPlanUnitPlayer.this.stopExceptions.add(e);
            }
            this.curLatch.countDown();
        }
    }
}

