/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import com.google.common.collect.ImmutableList;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.feedback.NullFeedbackManager;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.PlanPlayer;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitPlayException;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.util.RuntimeExceptionLoggingRunnable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiThreadedPlanPlayer<T extends TimedPlanUnit>
implements PlanPlayer {
    private final PlanManager<T> planManager;
    private final FeedbackManager fbManager;
    private Future<?> planRunner = null;
    private final ExecutorService exec = Executors.newSingleThreadExecutor();
    private static Logger logger = LoggerFactory.getLogger((String)MultiThreadedPlanPlayer.class.getName());
    private BlockingQueue<Double> timeQueue = new ArrayBlockingQueue<Double>(10);

    public MultiThreadedPlanPlayer(FeedbackManager bbm, PlanManager<T> planManager) {
        this.fbManager = bbm;
        this.planManager = planManager;
    }

    public MultiThreadedPlanPlayer(PlanManager<T> planManager) {
        this(NullFeedbackManager.getInstance(), planManager);
    }

    @Override
    public void setBMLBlockState(String bmlId, TimedPlanUnitState state) {
        this.planManager.setBMLBlockState(bmlId, state);
    }

    @Override
    public void interruptBehaviourBlock(String bmlId, double time) {
        this.planManager.interruptBehaviourBlock(bmlId, time);
    }

    public int getNumberOfPlanUnits() {
        return this.planManager.getNumberOfPlanUnits();
    }

    @Override
    public void interruptPlanUnit(String bmlId, String id, double globalTime) {
        this.planManager.interruptPlanUnit(bmlId, id, globalTime);
    }

    @Override
    public void play(double t) {
        logger.debug("enter play");
        try {
            this.timeQueue.put(t);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.planRunner == null || this.planRunner.isDone()) {
            logger.debug("Creating new SpeechRunner");
            if (this.planRunner != null) {
                logger.debug("speechRunner.iDone(): {}", (Object)this.planRunner.isDone());
            }
            this.planRunner = this.exec.submit((Runnable)new RuntimeExceptionLoggingRunnable((Runnable)new SpeechRunner()));
        }
    }

    @Override
    public void shutdown() {
        this.scheduleStop();
        this.exec.shutdown();
        try {
            this.exec.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("InterruptedException on MultiThreadedPlanPlayer shutdown:", (Throwable)e);
        }
    }

    public void scheduleStop() {
        try {
            this.timeQueue.put(-1.0);
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
        if (this.planRunner != null) {
            try {
                this.planRunner.get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            catch (ExecutionException e) {
                logger.warn("Execution Exception when trying to stop VerbalPlanPlayer thread: {}", (Throwable)e);
            }
        }
    }

    @Override
    public void reset(double time) {
        this.planManager.removeAllPlanUnits(time);
        logger.debug("Schedule VPP stop");
        this.scheduleStop();
        logger.debug("VPP cleared");
    }

    private void suException(TimedPlanUnit su, String message, double time) {
        logger.debug("suException with {}:{}", (Object)su.getBMLId(), (Object)su.getId());
        String bmlId = su.getBMLId();
        HashSet<String> droppedBehaviours = new HashSet<String>();
        droppedBehaviours.add(su.getId());
        HashSet modifiedConstraints = new HashSet();
        String warningText = message + "\nBehavior " + su.getBMLId() + ":" + su.getId() + " dropped.";
        this.exception(new BMLExceptionFeedback(bmlId, time, droppedBehaviours, modifiedConstraints, warningText, false));
    }

    protected void playUnit(T su, double t) throws TimedPlanUnitPlayException {
        if (su.getState().isLurking()) {
            su.start(t);
        }
        if (su.getState().isPlaying()) {
            su.play(t);
        }
    }

    public void exception(BMLExceptionFeedback e) {
        this.fbManager.exception(e);
    }

    public void addExceptionListener(BMLExceptionListener ws) {
        this.fbManager.addExceptionListener(ws);
    }

    public void removeAllExceptionListeners() {
        this.fbManager.removeAllExceptionListeners();
    }

    class SpeechRunner
    implements Runnable {
        SpeechRunner() {
        }

        @Override
        public void run() {
            logger.debug("start multithreadedplanplayer");
            ArrayList<TimedPlanUnit> planUnitsRemove = new ArrayList<TimedPlanUnit>();
            double time = 0.0;
            while (true) {
                try {
                    time = (Double)MultiThreadedPlanPlayer.this.timeQueue.take();
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                if (time == -1.0) break;
                ImmutableList planUnitsCache = MultiThreadedPlanPlayer.this.planManager.getPlanUnits();
                planUnitsRemove.clear();
                for (TimedPlanUnit su : planUnitsCache) {
                    if (!(time >= su.getStartTime())) continue;
                    try {
                        MultiThreadedPlanPlayer.this.playUnit(su, time);
                    }
                    catch (TimedPlanUnitPlayException e) {
                        logger.debug("TimedPlanUnitPlayException!");
                        MultiThreadedPlanPlayer.this.suException(su, e.getLocalizedMessage(), time);
                        planUnitsRemove.add(su);
                    }
                }
                MultiThreadedPlanPlayer.this.planManager.removePlanUnits(planUnitsRemove, time);
                MultiThreadedPlanPlayer.this.planManager.removeFinishedPlanUnits();
            }
            logger.debug("stopped verbalplanplayer");
        }
    }
}

