/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import hmi.elckerlyc.planunit.AbstractTimedPlanUnitPlayer;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitPlayException;

public class DefaultTimedPlanUnitPlayer
extends AbstractTimedPlanUnitPlayer {
    public DefaultTimedPlanUnitPlayer() {
        this.playExceptions = Lists.newArrayList();
        this.stopExceptions = Lists.newArrayList();
    }

    @Override
    public void playUnit(TimedPlanUnit su, double t) {
        try {
            if (su.getState().isLurking()) {
                su.start(t);
            }
            su.play(t);
        }
        catch (TimedPlanUnitPlayException e) {
            this.playExceptions.add(e);
        }
    }

    @Override
    public ImmutableCollection<TimedPlanUnitPlayException> getPlayExceptions() {
        return new ImmutableList.Builder().addAll((Iterable)this.playExceptions).build();
    }

    @Override
    public void stopUnit(TimedPlanUnit su, double t) {
        try {
            su.stop(t);
        }
        catch (TimedPlanUnitPlayException e) {
            this.stopExceptions.add(e);
        }
    }

    @Override
    public ImmutableCollection<TimedPlanUnitPlayException> getStopExceptions() {
        return new ImmutableList.Builder().addAll((Iterable)this.stopExceptions).build();
    }
}

