/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import com.google.common.collect.ImmutableCollection;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitPlayException;
import hmi.elckerlyc.planunit.TimedPlanUnitPlayer;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTimedPlanUnitPlayer
implements TimedPlanUnitPlayer {
    private static final Logger log = LoggerFactory.getLogger(AbstractTimedPlanUnitPlayer.class);
    protected List<TimedPlanUnitPlayException> playExceptions;
    protected List<TimedPlanUnitPlayException> stopExceptions;

    @Override
    public void handleStopExceptions(double t) {
        ImmutableCollection<TimedPlanUnitPlayException> exceptions = this.getStopExceptions();
        for (TimedPlanUnitPlayException tmuEx : exceptions) {
            log.warn("Exception stopping behaviour: ", (Throwable)tmuEx);
        }
        this.clearStopExceptions((Collection<TimedPlanUnitPlayException>)exceptions);
    }

    @Override
    public void handlePlayExceptions(double t, FeedbackManager fbManager) {
        ImmutableCollection<TimedPlanUnitPlayException> exceptions = this.getPlayExceptions();
        for (TimedPlanUnitPlayException tmuEx : exceptions) {
            TimedPlanUnit tmuR = tmuEx.getPlanUnit();
            fbManager.puException(tmuR, "Runtime exception for behavior " + tmuR.getBMLId() + ":" + tmuR.getId() + ":" + tmuEx.getLocalizedMessage() + ".", t);
            this.stopUnit(tmuR, t);
        }
        this.clearPlayExceptions((Collection<TimedPlanUnitPlayException>)exceptions);
    }

    @Override
    public void clearStopExceptions(Collection<TimedPlanUnitPlayException> removeExceptions) {
        this.stopExceptions.removeAll(removeExceptions);
    }

    @Override
    public void clearPlayExceptions(Collection<TimedPlanUnitPlayException> removeExceptions) {
        this.playExceptions.removeAll(removeExceptions);
    }
}

