/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.pegboard;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import hmi.elckerlyc.pegboard.PegKey;
import hmi.elckerlyc.pegboard.TimePeg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class TimePegMap {
    private Multimap<TimePeg, PegKey> inversePegMap = HashMultimap.create();
    private Map<PegKey, TimePeg> pegMap = new HashMap<PegKey, TimePeg>();

    TimePegMap() {
    }

    public synchronized void put(PegKey key, TimePeg tp) {
        this.pegMap.put(key, tp);
        this.inversePegMap.put((Object)tp.getLink(), (Object)key);
    }

    public synchronized TimePeg get(PegKey key) {
        return this.pegMap.get(key);
    }

    public synchronized ImmutableSet<PegKey> get(TimePeg tp) {
        return ImmutableSet.copyOf((Collection)this.inversePegMap.get((Object)tp.getLink()));
    }

    public synchronized void clear() {
        this.pegMap.clear();
        this.inversePegMap.clear();
    }

    public synchronized ImmutableSet<PegKey> getPegKeySet() {
        return ImmutableSet.copyOf(this.pegMap.keySet());
    }

    public synchronized void removeBehaviour(String bmlId, String id) {
        ArrayList<Map.Entry<PegKey, TimePeg>> removeEntries = new ArrayList<Map.Entry<PegKey, TimePeg>>();
        for (Map.Entry<PegKey, TimePeg> entry : this.pegMap.entrySet()) {
            if (!entry.getKey().getId().equals(id) || !entry.getKey().getBmlId().equals(bmlId)) continue;
            removeEntries.add(entry);
        }
        for (Map.Entry<PegKey, TimePeg> entry : removeEntries) {
            this.pegMap.remove(entry.getKey());
            Collection pks = this.inversePegMap.get((Object)entry.getValue().getLink());
            pks.remove(entry.getKey());
        }
    }
}

