/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.pegboard;

import hmi.elckerlyc.pegboard.BMLBlockPeg;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class TimePeg {
    public static final double VALUE_UNKNOWN = -1.7976931348623157E308;
    protected final BMLBlockPeg bmlBlockPeg;
    @GuardedBy(value="this")
    private double value;
    @GuardedBy(value="this")
    private boolean absoluteTime;

    public TimePeg(BMLBlockPeg bmp) {
        this.bmlBlockPeg = bmp;
        this.value = -1.7976931348623157E308;
        this.absoluteTime = false;
    }

    public synchronized BMLBlockPeg getBmlBlockPeg() {
        return this.bmlBlockPeg;
    }

    public synchronized String getBmlId() {
        return this.bmlBlockPeg.getId();
    }

    public synchronized boolean isAbsoluteTime() {
        return this.absoluteTime;
    }

    public synchronized void setAbsoluteTime(boolean absTime) {
        this.absoluteTime = absTime;
    }

    public synchronized TimePeg getLink() {
        return this;
    }

    public synchronized double getLocalValue() {
        return this.value;
    }

    public synchronized double getGlobalValue() {
        if (this.getLocalValue() == -1.7976931348623157E308) {
            return -1.7976931348623157E308;
        }
        return this.bmlBlockPeg.getValue() + this.getLocalValue();
    }

    public synchronized void setLocalValue(double v) {
        this.value = v;
    }

    public synchronized void setValue(double v, BMLBlockPeg p) {
        this.value = v + p.getValue() - this.bmlBlockPeg.getValue();
    }

    public synchronized void setGlobalValue(double v) {
        this.value = v == -1.7976931348623157E308 ? -1.7976931348623157E308 : v - this.bmlBlockPeg.getValue();
    }

    public synchronized String toString() {
        return "Time peg with local value " + this.getLocalValue() + " global value " + this.getGlobalValue();
    }
}

