/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.pegboard;

import com.google.common.collect.ImmutableSet;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.pegboard.BMLBlockPeg;
import hmi.elckerlyc.pegboard.PegKey;
import hmi.elckerlyc.pegboard.TimePeg;
import hmi.elckerlyc.pegboard.TimePegMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PegBoard {
    private final TimePegMap pegs = new TimePegMap();
    private final ConcurrentHashMap<String, BMLBlockPeg> bmlBlockPegs = new ConcurrentHashMap();
    private Logger logger = LoggerFactory.getLogger((String)PegBoard.class.getName());

    public PegBoard() {
        this.bmlBlockPegs.put(BMLBlockPeg.GLOBALPEG.getId(), BMLBlockPeg.GLOBALPEG);
    }

    public void clear() {
        this.pegs.clear();
        this.bmlBlockPegs.clear();
        this.bmlBlockPegs.put(BMLBlockPeg.GLOBALPEG.getId(), BMLBlockPeg.GLOBALPEG);
    }

    public void addBMLBlockPeg(BMLBlockPeg p) {
        this.bmlBlockPegs.put(p.getId(), p);
    }

    public BMLBlockPeg getBMLBlockPeg(String bmlId) {
        return this.bmlBlockPegs.get(bmlId);
    }

    public double getRelativePegTime(String bmlTargetId, TimePeg p) {
        if (p == null) {
            return -1.7976931348623157E308;
        }
        BMLBlockPeg bmlP = this.bmlBlockPegs.get(bmlTargetId);
        if (bmlP == null) {
            this.logger.warn("getRelativePegTime with invalid bmlTargetId {}", (Object)bmlTargetId);
            return -1.7976931348623157E308;
        }
        return p.getGlobalValue() - bmlP.getValue();
    }

    public double getRelativePegTime(String bmlTargetId, String bmlId, String behId, String syncId) {
        TimePeg p = this.pegs.get(new PegKey(bmlId, behId, syncId));
        if (p == null) {
            return -1.7976931348623157E308;
        }
        BMLBlockPeg bmlP = this.bmlBlockPegs.get(bmlTargetId);
        if (bmlP == null) {
            this.logger.warn("getRelativePegTime with invalid bmlTargetId {}", (Object)bmlTargetId);
            return -1.7976931348623157E308;
        }
        return p.getGlobalValue() - bmlP.getValue();
    }

    public double getPegTime(String bmlId, String id, String syncId) {
        TimePeg p = this.pegs.get(new PegKey(bmlId, id, syncId));
        if (p == null) {
            return -1.7976931348623157E308;
        }
        return p.getGlobalValue();
    }

    public void setPegTime(String bmlId, String id, String syncId, double time) {
        TimePeg p = this.pegs.get(new PegKey(bmlId, id, syncId));
        if (p != null) {
            p.setGlobalValue(time);
        }
    }

    public void setBMLBlockTime(String bmlId, double time) {
        BMLBlockPeg bp = this.bmlBlockPegs.get(bmlId);
        if (bp != null) {
            bp.setValue(time);
        }
    }

    public void addTimePegs(List<SyncAndTimePeg> satps) {
        for (SyncAndTimePeg satp : satps) {
            this.pegs.put(new PegKey(satp.bmlId, satp.id, satp.sync), satp.peg);
        }
    }

    public void addTimePeg(String bmlId, String id, String syncId, TimePeg p) {
        this.pegs.put(new PegKey(bmlId, id, syncId), p);
    }

    public TimePeg getTimePeg(String bmlId, String id, String syncId) {
        return this.pegs.get(new PegKey(bmlId, id, syncId));
    }

    public ImmutableSet<PegKey> getPegKeys(TimePeg tp) {
        return this.pegs.get(tp);
    }

    public Set<String> getTimedSyncs(String bmlId, String behId) {
        HashSet<String> syncs = new HashSet<String>();
        for (PegKey p : this.pegs.getPegKeySet()) {
            if (!p.id.equals(behId) || !p.bmlId.equals(bmlId) || this.getPegTime(p.bmlId, p.id, p.syncId) == -1.7976931348623157E308) continue;
            syncs.add(p.syncId);
        }
        return syncs;
    }

    public void removeBehaviour(String bmlId, String id) {
        this.pegs.removeBehaviour(bmlId, id);
    }
}

