/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.bridge;

import asap.utils.SchedulingClock;
import hmi.bml.bridge.RealizerPort;
import hmi.bml.ext.bmlt.feedback.BMLTSchedulingFinishedFeedback;
import hmi.bml.ext.bmlt.feedback.BMLTSchedulingListener;
import hmi.bml.ext.bmlt.feedback.BMLTSchedulingStartFeedback;
import hmi.bml.ext.bmlt.feedback.XMLBMLTSchedulingFinishedFeedback;
import hmi.bml.ext.bmlt.feedback.XMLBMLTSchedulingStartFeedback;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLListener;
import hmi.bml.feedback.BMLPerformanceStartFeedback;
import hmi.bml.feedback.BMLPerformanceStopFeedback;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.bml.feedback.BMLWarningFeedback;
import hmi.bml.feedback.BMLWarningListener;
import hmi.bml.feedback.XMLBMLExceptionFeedback;
import hmi.bml.feedback.XMLBMLPerformanceStartFeedback;
import hmi.bml.feedback.XMLBMLPerformanceStopFeedback;
import hmi.bml.feedback.XMLBMLSyncPointProgressFeedback;
import hmi.bml.feedback.XMLBMLWarningFeedback;
import org.slf4j.Logger;

public class LogPipe
implements RealizerPort,
BMLFeedbackListener,
BMLExceptionListener,
BMLWarningListener,
BMLTSchedulingListener {
    private final Logger requestLogger;
    private final Logger feedbackLogger;
    private final RealizerPort outputBridge;
    private final SchedulingClock clock;
    private final boolean logRequests;
    private final boolean logFeedback;

    public LogPipe(Logger rl, Logger fl, RealizerPort outBridge, SchedulingClock clock) {
        this.requestLogger = rl;
        this.feedbackLogger = fl;
        this.outputBridge = outBridge;
        this.clock = clock;
        this.logRequests = rl != null;
        this.logFeedback = fl != null;
        this.outputBridge.addListeners(new BMLListener[]{this});
    }

    public void performanceStop(BMLPerformanceStopFeedback psf) {
        if (this.logFeedback) {
            this.feedbackLogger.info(new XMLBMLPerformanceStopFeedback(psf).toXMLString());
        }
    }

    public void performanceStart(BMLPerformanceStartFeedback psf) {
        if (this.logFeedback) {
            this.feedbackLogger.info(new XMLBMLPerformanceStartFeedback(psf).toXMLString());
        }
    }

    public void syncProgress(BMLSyncPointProgressFeedback spp) {
        if (this.logFeedback) {
            this.feedbackLogger.info(new XMLBMLSyncPointProgressFeedback(spp).toXMLString());
        }
    }

    public void exception(BMLExceptionFeedback be) {
        if (this.logFeedback) {
            this.feedbackLogger.info(new XMLBMLExceptionFeedback(be).toXMLString());
        }
    }

    public void warn(BMLWarningFeedback bw) {
        if (this.logFeedback) {
            this.feedbackLogger.info(new XMLBMLWarningFeedback(bw).toXMLString());
        }
    }

    public void schedulingFinished(BMLTSchedulingFinishedFeedback pff) {
        if (this.logFeedback) {
            this.feedbackLogger.info(new XMLBMLTSchedulingFinishedFeedback(pff).toXMLString());
        }
    }

    public void schedulingStart(BMLTSchedulingStartFeedback psf) {
        if (this.logFeedback) {
            this.feedbackLogger.info(new XMLBMLTSchedulingStartFeedback(psf).toXMLString());
        }
    }

    public void addListeners(BMLListener ... listeners) {
        this.outputBridge.addListeners(listeners);
    }

    public void performBML(String bmlString) {
        if (this.logRequests) {
            this.requestLogger.info("<entry name=\"{}\" time=\"{}\">", (Object)this.requestLogger.getName(), (Object)this.clock.getTime());
            this.requestLogger.info(bmlString);
            this.requestLogger.info("</entry>");
        }
        this.outputBridge.performBML(bmlString);
    }

    public void removeAllListeners() {
        this.outputBridge.removeAllListeners();
        this.outputBridge.addListeners(new BMLListener[]{this});
    }
}

