/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.bridge;

import hmi.bml.bridge.RealizerPort;
import hmi.bml.ext.bmlt.feedback.BMLTSchedulingListener;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLListener;
import hmi.bml.feedback.BMLWarningListener;
import hmi.elckerlyc.ElckerlycRealizer;

public class ElckerlycRealizerPipe
implements RealizerPort {
    private ElckerlycRealizer realizer;

    public ElckerlycRealizerPipe(ElckerlycRealizer realizer) {
        this.realizer = realizer;
    }

    public void performBML(String bmlString) {
        this.realizer.scheduleBML(bmlString);
    }

    public void addPlanningListener(BMLTSchedulingListener bpl) {
        this.realizer.addPlanningListener(bpl);
    }

    public void removeAllListeners() {
        this.realizer.getScheduler().removeAllExceptionListeners();
        this.realizer.getScheduler().removeAllWarningListeners();
        this.realizer.getScheduler().removeAllFeedbackListeners();
        this.realizer.getScheduler().removeAllPlanningListeners();
    }

    public void addListeners(BMLListener ... listeners) {
        for (BMLListener listener : listeners) {
            if (listener instanceof BMLExceptionListener) {
                this.realizer.addExceptionListener((BMLExceptionListener)listener);
            }
            if (listener instanceof BMLWarningListener) {
                this.realizer.addWarningListener((BMLWarningListener)listener);
            }
            if (listener instanceof BMLFeedbackListener) {
                this.realizer.addFeedbackListener((BMLFeedbackListener)listener);
            }
            if (!(listener instanceof BMLTSchedulingListener)) continue;
            this.realizer.addPlanningListener((BMLTSchedulingListener)listener);
        }
    }
}

