/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitPlayer;
import java.util.Collection;
import java.util.List;

public class DefaultTimedPlanUnitPlayer
implements TimedPlanUnitPlayer {
    private List<TimedPlanUnitPlayException> playExceptions = Lists.newArrayList();
    private List<TimedPlanUnitPlayException> stopExceptions = Lists.newArrayList();

    @Override
    public void playUnit(TimedPlanUnit su, double t) {
        try {
            if (su.getState().isLurking()) {
                su.start(t);
            }
            su.play(t);
        }
        catch (TimedPlanUnitPlayException e) {
            this.playExceptions.add(e);
        }
    }

    @Override
    public ImmutableCollection<TimedPlanUnitPlayException> getPlayExceptions() {
        return new ImmutableList.Builder().addAll(this.playExceptions).build();
    }

    @Override
    public void clearPlayExceptions(Collection<TimedPlanUnitPlayException> removeExceptions) {
        this.playExceptions.removeAll(removeExceptions);
    }

    @Override
    public void stopUnit(TimedPlanUnit su, double t) {
        try {
            su.stop(t);
        }
        catch (TimedPlanUnitPlayException e) {
            this.stopExceptions.add(e);
        }
    }

    @Override
    public ImmutableCollection<TimedPlanUnitPlayException> getStopExceptions() {
        return new ImmutableList.Builder().addAll(this.stopExceptions).build();
    }

    @Override
    public void clearStopExceptions(Collection<TimedPlanUnitPlayException> removeExceptions) {
        this.stopExceptions.removeAll(removeExceptions);
    }
}

