/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.parametervaluechange;

import hmi.bml.BMLSync;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviorNotFoundException;
import hmi.elckerlyc.SyncPointNotFoundException;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.parametervaluechange.ParameterValueInfo;
import hmi.elckerlyc.parametervaluechange.ParameterValueTrajectory;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.TimedAbstractPlanUnit;
import hmi.elckerlyc.scheduler.BMLScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedParameterValueChangeUnit
extends TimedAbstractPlanUnit {
    private TimePeg startPeg;
    private TimePeg strokePeg;
    private final ParameterValueTrajectory trajectory;
    private final BMLScheduler scheduler;
    private final String paramId;
    private final String targetId;
    private final String targetBmlId;
    private final String replacementGroup;
    private float initialValue;
    private final float targetValue;
    private final boolean hasInitialValue;
    private volatile boolean strokeFeedbackSent = false;
    private static final Logger logger = LoggerFactory.getLogger((String)TimedParameterValueChangeUnit.class.getName());

    public TimedParameterValueChangeUnit(FeedbackManager bfm, BMLBlockPeg bmlPeg, String bmlId, String behId, BMLScheduler sched, ParameterValueInfo paramValInfo, ParameterValueTrajectory traj) {
        super(bfm, bmlPeg, bmlId, behId);
        this.trajectory = traj;
        this.scheduler = sched;
        this.paramId = paramValInfo.getParamId();
        this.targetId = paramValInfo.getTargetId();
        this.targetBmlId = paramValInfo.getTargetBmlId();
        this.initialValue = paramValInfo.getInitialValue();
        this.targetValue = paramValInfo.getTargetValue();
        this.hasInitialValue = paramValInfo.hasInitialValue();
        this.strokePeg = new TimePeg(bmlPeg);
        this.startPeg = new TimePeg(bmlPeg);
        this.replacementGroup = this.targetBmlId + ":" + this.targetId + ":" + this.paramId + ":replacementgroup";
    }

    @Override
    public double getStartTime() {
        return this.startPeg.getGlobalValue();
    }

    public void setStartPeg(TimePeg startPeg) {
        this.startPeg = startPeg;
        logger.debug("Setting start peg to {}", (Object)startPeg);
    }

    public void setStrokePeg(TimePeg strokePeg) {
        this.strokePeg = strokePeg;
        logger.debug("Setting stroke peg to {}", (Object)strokePeg);
    }

    @Override
    public double getEndTime() {
        return -1.7976931348623157E308;
    }

    @Override
    public double getRelaxTime() {
        return this.getEndTime();
    }

    @Override
    public TimePeg getTimePeg(String syncId) {
        if (syncId.equals("start")) {
            return this.startPeg;
        }
        if (syncId.equals("stroke")) {
            return this.strokePeg;
        }
        return null;
    }

    @Override
    public void setTimePeg(String syncId, TimePeg peg) {
        if (BMLSync.isBMLSync((String)syncId)) {
            if (syncId.equals("start")) {
                this.startPeg = peg;
            } else if (syncId.equals("stroke")) {
                this.strokePeg = peg;
            } else {
                logger.warn("Can't set TimePeg for {} on parameter value change behavior", (Object)syncId);
            }
        } else {
            logger.warn("Can't set TimePeg for non-BML sync {}", (Object)syncId);
        }
    }

    @Override
    public boolean hasValidTiming() {
        if (this.strokePeg.getGlobalValue() != -1.7976931348623157E308 && this.startPeg.getGlobalValue() != -1.7976931348623157E308) {
            return this.strokePeg.getGlobalValue() >= this.startPeg.getGlobalValue();
        }
        return true;
    }

    @Override
    public double getRelativeTime(String syncId) throws SyncPointNotFoundException {
        if (syncId.equals("start") || syncId.equals("ready") || syncId.equals("stroke_start")) {
            return 0.0;
        }
        if (syncId.equals("stroke_end") || syncId.equals("stroke") || syncId.equals("relax") || syncId.equals("end")) {
            return 1.0;
        }
        throw new SyncPointNotFoundException(this.getBMLId(), this.getId(), syncId);
    }

    @Override
    public double getTime(String syncId) {
        if (syncId.equals("start") || syncId.equals("ready") || syncId.equals("stroke_start")) {
            return this.getStartTime();
        }
        if (syncId.equals("stroke")) {
            return this.strokePeg.getGlobalValue();
        }
        return -1.7976931348623157E308;
    }

    @Override
    protected void playUnit(double time) throws TimedPlanUnitPlayException {
        double t = 1.0;
        if (this.strokePeg.getGlobalValue() != -1.7976931348623157E308 && time < this.strokePeg.getGlobalValue()) {
            t = (time - this.getStartTime()) / (this.strokePeg.getGlobalValue() - this.startPeg.getGlobalValue());
        }
        if (this.fbManager.getSyncsPassed(this.targetBmlId, this.targetId).contains((Object)"end")) {
            logger.debug("End passed for {}:{}, stopping parametervaluechange behavior", (Object)this.targetBmlId, (Object)this.targetId);
            this.stop(time);
            return;
        }
        try {
            logger.debug("Setting parameter value {} in {}:{} to {})", new Object[]{this.paramId, this.targetBmlId, this.targetId, Float.valueOf(this.trajectory.getValue(this.initialValue, this.targetValue, (float)t))});
            this.scheduler.setParameterValue(this.targetBmlId, this.targetId, this.paramId, this.trajectory.getValue(this.initialValue, this.targetValue, (float)t));
        }
        catch (ParameterException e) {
            throw new TimedPlanUnitPlayException("Parameter " + this.paramId + " not valid for " + this.targetBmlId + ":" + this.targetId, this, e);
        }
        catch (BehaviorNotFoundException e) {
            throw new TimedPlanUnitPlayException("Behavior " + this.targetBmlId + ":" + this.targetId + " not found.", this, e);
        }
        if (t >= 1.0 && !this.strokeFeedbackSent) {
            this.strokeFeedbackSent = true;
            this.sendFeedback("stroke", time);
            this.stop(time);
        }
    }

    @Override
    protected void stopUnit(double time) throws TimedPlanUnitPlayException {
        if (!this.strokeFeedbackSent) {
            this.sendFeedback("stroke", time);
        }
        this.sendFeedback("stroke_end", time);
        this.sendFeedback("relax", time);
        this.sendFeedback("end", time);
    }

    @Override
    protected void startUnit(double time) throws TimedPlanUnitPlayException {
        this.sendFeedback("start", time);
        this.sendFeedback("ready", time);
        this.sendFeedback("stroke_start", time);
        if (!this.hasInitialValue) {
            try {
                this.initialValue = this.scheduler.getFloatParameterValue(this.targetBmlId, this.targetId, this.paramId);
            }
            catch (ParameterException e) {
                throw new TimedPlanUnitPlayException("ParameterException", this, e);
            }
            catch (BehaviorNotFoundException e) {
                throw new TimedPlanUnitPlayException("BehaviorNotFoundException", this, e);
            }
        }
    }

    @Override
    public String getReplacementGroup() {
        return this.replacementGroup;
    }
}

