/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.faceengine.faceunit;

import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.SyncPointNotFoundException;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.faceengine.faceunit.FUPlayException;
import hmi.elckerlyc.faceengine.faceunit.FaceUnit;
import hmi.elckerlyc.faceengine.faceunit.TFUPlayException;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.elckerlyc.planunit.PlanUnitTimeManager;
import hmi.elckerlyc.planunit.TimedAbstractPlanUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TimedFaceUnit
extends TimedAbstractPlanUnit {
    public final FaceUnit fu;
    protected ArrayList<KeyPosition> progressHandled = new ArrayList();
    private final PlanUnitTimeManager puTimeManager;

    public TimedFaceUnit(FeedbackManager bfm, BMLBlockPeg bbPeg, String bmlId, String id, FaceUnit f) {
        super(bfm, bbPeg, bmlId, id);
        this.fu = f;
        this.puTimeManager = new PlanUnitTimeManager(f);
    }

    public KeyPosition getKeyPosition(String kid) {
        return this.fu.getKeyPosition(kid);
    }

    private void sendProgress(double t, double time) {
        for (KeyPosition k : this.fu.getKeyPositions()) {
            if (k.time <= t) {
                if (this.progressHandled.contains(k)) continue;
                String bmlId = this.getBMLId();
                String behaviorId = this.getId();
                String syncId = k.id;
                double bmlBlockTime = time - this.bmlBlockPeg.getValue();
                this.feedback(new BMLSyncPointProgressFeedback(bmlId, behaviorId, syncId, bmlBlockTime, time));
                this.progressHandled.add(k);
                continue;
            }
            if (!this.progressHandled.contains(k)) continue;
            this.progressHandled.remove(k);
        }
    }

    @Override
    public void playUnit(double time) throws TimedPlanUnitPlayException {
        double t = this.puTimeManager.getRelativeTime(time);
        try {
            this.fu.play(t);
        }
        catch (FUPlayException ex) {
            throw new TFUPlayException(ex.getLocalizedMessage(), this, (Exception)ex);
        }
        this.sendProgress(t, time);
    }

    public void cleanup() {
        this.fu.cleanup();
    }

    public FaceUnit getFaceUnit() {
        return this.fu;
    }

    @Override
    protected void stopUnit(double time) throws TimedPlanUnitPlayException {
        this.sendProgress(1.0, time);
        this.cleanup();
    }

    @Override
    public String getReplacementGroup() {
        return this.fu.getReplacementGroup();
    }

    @Override
    public double getPreferedDuration() {
        return this.fu.getPreferedDuration();
    }

    @Override
    public void setParameterValue(String paramId, String value) throws ParameterException {
        try {
            this.fu.setParameterValue(paramId, value);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitParameterNotFoundException(e);
        }
    }

    @Override
    public void setFloatParameterValue(String paramId, float value) throws ParameterException {
        try {
            this.fu.setFloatParameterValue(paramId, value);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitFloatParameterNotFoundException(e);
        }
    }

    @Override
    public float getFloatParameterValue(String paramId) throws ParameterException {
        try {
            return this.fu.getFloatParameterValue(paramId);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitFloatParameterNotFoundException(e);
        }
    }

    @Override
    public String getParameterValue(String paramId) throws ParameterException {
        try {
            return this.fu.getParameterValue(paramId);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitParameterNotFoundException(e);
        }
    }

    public void setPegs(Map<KeyPosition, TimePeg> pegs) {
        this.puTimeManager.setPegs(pegs);
    }

    @Override
    public double getRelativeTime(String syncId) throws SyncPointNotFoundException {
        return this.puTimeManager.getRelativeTime(syncId);
    }

    public Map<KeyPosition, TimePeg> getPegs() {
        return this.puTimeManager.getPegs();
    }

    @Override
    public boolean hasValidTiming() {
        return this.puTimeManager.hasValidTiming();
    }

    public KeyPosition getKeyPosition(TimePeg sp) {
        return this.puTimeManager.getKeyPosition(sp);
    }

    public double getPrevPegTime(String pid) {
        return this.puTimeManager.getPrevPegTime(pid);
    }

    public double getNextPegTime(String pid) {
        return this.puTimeManager.getNextPegTime(pid);
    }

    @Override
    public double getTime(String pid) {
        return this.puTimeManager.getTime(pid);
    }

    @Override
    public TimePeg getTimePeg(String pid) {
        return this.puTimeManager.getTimePeg(pid);
    }

    @Override
    public double getStartTime() {
        return this.puTimeManager.getStartTime();
    }

    @Override
    public double getEndTime() {
        return this.puTimeManager.getEndTime();
    }

    @Override
    public double getRelaxTime() {
        return this.puTimeManager.getRelaxTime();
    }

    public void setTimePeg(KeyPosition kp, TimePeg sp) {
        this.puTimeManager.setTimePeg(kp, sp);
    }

    @Override
    public void setTimePeg(String kid, TimePeg sp) {
        this.puTimeManager.setTimePeg(kid, sp);
    }

    public void resolveDefaultBMLKeyPositions() {
        this.puTimeManager.resolveDefaultBMLKeyPositions();
    }

    public double getRelativeTime(double absoluteTime) {
        return this.puTimeManager.getRelativeTime(absoluteTime);
    }

    @Override
    public List<String> getAvailableSyncs() {
        return this.puTimeManager.getAvailableSyncs();
    }
}

