/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.faceengine;

import hmi.bml.core.Behaviour;
import hmi.bml.core.FaceBehaviour;
import hmi.bml.ext.bmlt.BMLTFaceMorphBehaviour;
import hmi.elckerlyc.AbstractPlanner;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.faceengine.facebinding.FaceBinding;
import hmi.elckerlyc.faceengine.faceunit.TimedFaceUnit;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.scheduler.LinearStretchResolver;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import hmi.elckerlyc.scheduler.UniModalResolver;
import hmi.faceanimation.FaceController;
import hmi.faceanimation.converters.EmotionConverter;
import hmi.faceanimation.converters.FACSConverter;
import java.util.ArrayList;
import java.util.List;

public class FacePlanner
extends AbstractPlanner {
    private FaceController faceController;
    private FACSConverter facsConverter;
    private EmotionConverter emotionConverter;
    private final FaceBinding faceBinding;
    private UniModalResolver resolver;

    public FacePlanner(FeedbackManager bfm, FaceController fc, FACSConverter fconv, EmotionConverter econv, FaceBinding fb, PlanManager planManager) {
        super(bfm, planManager);
        this.faceBinding = fb;
        this.faceController = fc;
        this.facsConverter = fconv;
        this.emotionConverter = econv;
        this.resolver = new LinearStretchResolver();
    }

    public FaceBinding getFaceBinding() {
        return this.faceBinding;
    }

    @Override
    public List<SyncAndTimePeg> addBehaviour(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sacs, TimedPlanUnit planElement) throws BehaviourPlanningException {
        TimedFaceUnit tfu;
        ArrayList<SyncAndTimePeg> satps = new ArrayList<SyncAndTimePeg>();
        if (planElement == null) {
            List<TimedFaceUnit> tfus = this.faceBinding.getFaceUnit(this.fbManager, bbPeg, b, this.faceController, this.facsConverter, this.emotionConverter);
            if (tfus.isEmpty()) {
                throw new BehaviourPlanningException(b, "Behavior " + b.id + " could not be constructed from the face binding (no matching constraints), behavior omitted.");
            }
            tfu = tfus.get(0);
            if (!tfu.getFaceUnit().hasValidParameters()) {
                throw new BehaviourPlanningException(b, "Behavior " + b.id + " could not be constructed from the face binding because the parameters are not valid, behavior omitted.");
            }
        } else {
            tfu = (TimedFaceUnit)planElement;
        }
        tfu.resolveDefaultBMLKeyPositions();
        this.linkSynchs(tfu, sacs);
        this.planManager.addPlanUnit(tfu);
        for (KeyPosition kp : tfu.getPegs().keySet()) {
            TimePeg p = tfu.getPegs().get(kp);
            satps.add(new SyncAndTimePeg(b.getBmlId(), b.id, kp.id, p));
        }
        return satps;
    }

    @Override
    public TimedPlanUnit resolveSynchs(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sac) throws BehaviourPlanningException {
        List<TimedFaceUnit> tfus = this.faceBinding.getFaceUnit(this.fbManager, bbPeg, b, this.faceController, this.facsConverter, this.emotionConverter);
        if (tfus.isEmpty()) {
            throw new BehaviourPlanningException(b, "Behavior " + b.id + " could not be constructed from the face binding (no matching constraints), behavior omitted.");
        }
        TimedFaceUnit tfu = tfus.get(0);
        if (!tfu.getFaceUnit().hasValidParameters()) {
            throw new BehaviourPlanningException(b, "Behavior " + b.id + " could not be constructed from the face binding because the parameters are not valid, behavior omitted.");
        }
        tfu.resolveDefaultBMLKeyPositions();
        this.resolver.resolveSynchs(bbPeg, b, sac, tfu);
        return tfu;
    }

    private void linkSynchs(TimedFaceUnit tfu, List<TimePegAndConstraint> sacs) {
        for (TimePegAndConstraint s : sacs) {
            for (KeyPosition kp : tfu.getFaceUnit().getKeyPositions()) {
                if (!s.syncId.equals(kp.id)) continue;
                if (s.offset == 0.0) {
                    tfu.setTimePeg(kp, s.peg);
                    continue;
                }
                tfu.setTimePeg(kp, (TimePeg)new OffsetPeg(s.peg, -s.offset));
            }
        }
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedBehaviours() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(FaceBehaviour.class);
        list.add(BMLTFaceMorphBehaviour.class);
        return list;
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedDescriptionExtensions() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        return list;
    }

    @Override
    public double getRigidity(Behaviour beh) {
        return 0.5;
    }
}

