/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.bridge;

import hmi.bml.bridge.RealizerPort;
import hmi.bml.ext.bmlt.feedback.BMLTSchedulingFinishedFeedback;
import hmi.bml.ext.bmlt.feedback.BMLTSchedulingListener;
import hmi.bml.ext.bmlt.feedback.BMLTSchedulingStartFeedback;
import hmi.bml.ext.bmlt.feedback.XMLBMLTSchedulingFinishedFeedback;
import hmi.bml.ext.bmlt.feedback.XMLBMLTSchedulingStartFeedback;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLListener;
import hmi.bml.feedback.BMLPerformanceStartFeedback;
import hmi.bml.feedback.BMLPerformanceStopFeedback;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.bml.feedback.BMLWarningFeedback;
import hmi.bml.feedback.BMLWarningListener;
import hmi.bml.feedback.XMLBMLExceptionFeedback;
import hmi.bml.feedback.XMLBMLPerformanceStartFeedback;
import hmi.bml.feedback.XMLBMLPerformanceStopFeedback;
import hmi.bml.feedback.XMLBMLSyncPointProgressFeedback;
import hmi.bml.feedback.XMLBMLWarningFeedback;
import hmi.elckerlyc.scheduler.SchedulingClock;
import org.slf4j.Logger;

public class LoggingRealizerBridge
implements RealizerPort,
BMLFeedbackListener,
BMLExceptionListener,
BMLWarningListener,
BMLTSchedulingListener {
    private final Logger logger;
    private final RealizerPort outputBridge;
    private final SchedulingClock clock;
    private final boolean logRequests;
    private final boolean logFeedback;

    public LoggingRealizerBridge(Logger logger, RealizerPort outBridge, SchedulingClock clock) {
        this(logger, outBridge, clock, true, true);
    }

    public LoggingRealizerBridge(Logger logger, RealizerPort outBridge, SchedulingClock clock, boolean logR, boolean logF) {
        this.logger = logger;
        this.outputBridge = outBridge;
        this.clock = clock;
        this.logRequests = logR;
        this.logFeedback = logF;
        this.outputBridge.addListeners(new BMLListener[]{this});
    }

    public void performanceStop(BMLPerformanceStopFeedback psf) {
        if (this.logFeedback) {
            this.logger.info(new XMLBMLPerformanceStopFeedback(psf).toXMLString());
        }
    }

    public void performanceStart(BMLPerformanceStartFeedback psf) {
        if (this.logFeedback) {
            this.logger.info(new XMLBMLPerformanceStartFeedback(psf).toXMLString());
        }
    }

    public void syncProgress(BMLSyncPointProgressFeedback spp) {
        if (this.logFeedback) {
            this.logger.info(new XMLBMLSyncPointProgressFeedback(spp).toXMLString());
        }
    }

    public void exception(BMLExceptionFeedback be) {
        if (this.logFeedback) {
            this.logger.info(new XMLBMLExceptionFeedback(be).toXMLString());
        }
    }

    public void warn(BMLWarningFeedback bw) {
        if (this.logFeedback) {
            this.logger.info(new XMLBMLWarningFeedback(bw).toXMLString());
        }
    }

    public void schedulingFinished(BMLTSchedulingFinishedFeedback pff) {
        if (this.logFeedback) {
            this.logger.info(new XMLBMLTSchedulingFinishedFeedback(pff).toXMLString());
        }
    }

    public void schedulingStart(BMLTSchedulingStartFeedback psf) {
        if (this.logFeedback) {
            this.logger.info(new XMLBMLTSchedulingStartFeedback(psf).toXMLString());
        }
    }

    public void addListeners(BMLListener ... listeners) {
        this.outputBridge.addListeners(listeners);
    }

    public void performBML(String bmlString) {
        if (this.logRequests) {
            this.logger.info("<entry name=\"{}\" time=\"{}\">", (Object)this.logger.getName(), (Object)this.clock.getTime());
            this.logger.info(bmlString);
            this.logger.info("</entry>");
        }
        this.outputBridge.performBML(bmlString);
    }

    public void removeAllListeners() {
        this.outputBridge.removeAllListeners();
    }
}

