/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.elckerlyc.audioengine.WavUnit;
import hmi.elckerlyc.audioengine.WavUnitPlanningException;
import hmi.elckerlyc.audioengine.WavUnitPlayException;
import hmi.elckerlyc.planunit.InvalidParameterException;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.util.StringUtil;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import org.lwjgl.util.WaveData;

public class WavLWJGLJoalUnit
implements WavUnit {
    private IntBuffer buffer = BufferUtils.createIntBuffer((int)1);
    private final int source;
    private FloatBuffer sourcePos = BufferUtils.createFloatBuffer((int)3).put(new float[]{0.0f, 0.0f, 0.0f});
    private FloatBuffer sourceVel = BufferUtils.createFloatBuffer((int)3).put(new float[]{0.0f, 0.0f, 0.0f});
    private FloatBuffer listenerPos = BufferUtils.createFloatBuffer((int)3).put(new float[]{0.0f, 0.0f, 0.0f});
    private FloatBuffer listenerVel = BufferUtils.createFloatBuffer((int)3).put(new float[]{0.0f, 0.0f, 0.0f});
    private FloatBuffer listenerOri = BufferUtils.createFloatBuffer((int)6).put(new float[]{0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f});
    private float volume = 50.0f;
    private double duration = 0.0;
    private boolean removeSourceOnStop = false;

    private void setup(InputStream inputStream) throws WavUnitPlanningException {
        this.sourcePos.flip();
        this.sourceVel.flip();
        this.listenerPos.flip();
        this.listenerVel.flip();
        this.listenerOri.flip();
        AL10.alGenBuffers((IntBuffer)this.buffer);
        WaveData waveFile = WaveData.create((InputStream)inputStream);
        AL10.alBufferData((int)this.buffer.get(0), (int)waveFile.format, (ByteBuffer)waveFile.data, (int)waveFile.samplerate);
        waveFile.dispose();
        int sizeInBytes = AL10.alGetBufferi((int)this.buffer.get(0), (int)8196);
        int channels = AL10.alGetBufferi((int)this.buffer.get(0), (int)8195);
        int bits = AL10.alGetBufferi((int)this.buffer.get(0), (int)8194);
        long lengthInSamples = sizeInBytes * 8 / (channels * bits);
        int frequency = AL10.alGetBufferi((int)this.buffer.get(0), (int)8193);
        this.duration = (double)lengthInSamples / (double)frequency;
        AL10.alSourcef((int)this.source, (int)4099, (float)1.0f);
        AL10.alSourcef((int)this.source, (int)4106, (float)1.0f);
        AL10.alSource((int)this.source, (int)4100, (FloatBuffer)this.sourcePos);
        AL10.alSource((int)this.source, (int)4102, (FloatBuffer)this.sourceVel);
        AL10.alListener((int)4100, (FloatBuffer)this.listenerPos);
        AL10.alListener((int)4102, (FloatBuffer)this.listenerVel);
        AL10.alListener((int)4111, (FloatBuffer)this.listenerOri);
    }

    public WavLWJGLJoalUnit(InputStream inputStream) throws WavUnitPlanningException {
        IntBuffer src = BufferUtils.createIntBuffer((int)1);
        this.source = src.get(0);
        this.removeSourceOnStop = true;
        this.setup(inputStream);
    }

    public WavLWJGLJoalUnit(InputStream inputStream, int source) throws WavUnitPlanningException {
        this.source = source;
        this.setup(inputStream);
    }

    @Override
    public void setParameterValue(String parameter, float value) throws ParameterException {
        if (parameter.equals("volume")) {
            AL10.alSourcef((int)this.source, (int)4106, (float)(value / 100.0f));
        }
    }

    @Override
    public void setParameterValue(String parameter, String value) throws ParameterException {
        if (!StringUtil.isNumeric((String)value)) {
            throw new InvalidParameterException(parameter, value);
        }
        this.setParameterValue(parameter, Float.parseFloat(value));
    }

    @Override
    public String getParameterValue(String parameter) throws ParameterException {
        return "" + this.getFloatParameterValue(parameter);
    }

    @Override
    public float getFloatParameterValue(String parameter) throws ParameterException {
        if (parameter.equals("volume")) {
            return this.volume;
        }
        throw new ParameterNotFoundException(parameter);
    }

    @Override
    public void stop() {
        AL10.alSourceStop((int)this.source);
        if (this.removeSourceOnStop) {
            AL10.alDeleteSources((int)this.source);
        }
        AL10.alDeleteBuffers((IntBuffer)this.buffer);
    }

    @Override
    public void start(double relTime) {
        AL10.alSourcei((int)this.source, (int)4105, (int)this.buffer.get(0));
        AL10.alSourcef((int)this.source, (int)4106, (float)this.volume);
        AL10.alSourcePlay((int)this.source);
    }

    @Override
    public void play(double relTime) throws WavUnitPlayException {
    }

    @Override
    public double getDuration() {
        return this.duration;
    }
}

