/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.elckerlyc.audioengine.WavUnit;
import hmi.elckerlyc.audioengine.WavUnitPlanningException;
import hmi.elckerlyc.audioengine.WavUnitPlayException;
import hmi.elckerlyc.planunit.InvalidParameterException;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WavClipUnit
implements WavUnit {
    private final AudioInputStream audioStream;
    private final AudioFormat audioFormat;
    private final long audioLength;
    private final long audioFrameLength;
    private int audioReadPos = 0;
    private byte[] audioData = null;
    private static final int AUDIO_READ_BUFFER_SIZE = 65535;
    private static final double AUDIOPOSITION_UPDATE_DELTA = 0.066;
    private Clip outputLine;
    private final Object clipLock = new Object();
    public volatile boolean playing = false;
    public volatile boolean stop = false;
    private boolean firstPlay = false;
    private float desiredVolume = 50.0f;
    private final boolean syncAudio = false;
    private static Logger logger = LoggerFactory.getLogger((String)WavClipUnit.class.getName());

    public WavClipUnit(InputStream inputStream) throws WavUnitPlanningException {
        try {
            this.audioStream = AudioSystem.getAudioInputStream(inputStream);
        }
        catch (UnsupportedAudioFileException e1) {
            throw new WavUnitPlanningException(e1.getLocalizedMessage(), this, e1);
        }
        catch (IOException e1) {
            throw new WavUnitPlanningException(e1.getLocalizedMessage(), this, e1);
        }
        this.audioFrameLength = this.audioStream.getFrameLength();
        this.audioLength = this.audioStream.getFrameLength() * (long)this.audioStream.getFormat().getFrameSize();
        this.audioData = new byte[(int)this.audioLength];
        this.audioFormat = this.audioStream.getFormat();
        this.audioReadPos = 0;
        while ((long)this.audioReadPos < this.audioLength) {
            long size = 65535L;
            if (size > this.audioLength - (long)this.audioReadPos) {
                size = this.audioLength - (long)this.audioReadPos;
            }
            try {
                this.audioReadPos += this.audioStream.read(this.audioData, this.audioReadPos, (int)size);
            }
            catch (IOException e) {
                throw new WavUnitPlanningException(e.getLocalizedMessage(), this, e);
            }
        }
        try {
            this.audioStream.close();
        }
        catch (IOException e) {
            throw new WavUnitPlanningException(e.getLocalizedMessage(), this, e);
        }
    }

    @Override
    public double getDuration() {
        logger.debug("WAVUNIT AUDIO FRAME LENGTH: " + this.audioFrameLength);
        logger.debug("WAVUNIT SAMPLERATE: " + this.audioFormat.getSampleRate());
        return (double)this.audioFrameLength / (double)this.audioFormat.getSampleRate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVolume(float value) {
        Object object = this.clipLock;
        synchronized (object) {
            logger.debug("Setting wav volume to {}", (Object)Float.valueOf(value));
            FloatControl volume = (FloatControl)this.outputLine.getControl(FloatControl.Type.MASTER_GAIN);
            float minA = (float)Math.pow(10.0, volume.getMinimum() / 20.0f);
            float maxA = (float)Math.pow(10.0, volume.getMaximum() / 20.0f);
            float currentA = minA + (maxA - minA) * (value / 100.0f);
            float gainDb = (float)(20.0 * Math.log(currentA) / Math.log(10.0));
            volume.setValue(gainDb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameterValue(String parameter, float value) throws ParameterNotFoundException {
        logger.debug("Setting WavClipUnitParameter {} to {}", (Object)parameter, (Object)Float.valueOf(value));
        if (parameter.equals("volume")) {
            Object object = this.clipLock;
            synchronized (object) {
                this.desiredVolume = value;
                if (this.outputLine == null) {
                    return;
                }
                this.setVolume(value);
            }
        } else {
            throw new ParameterNotFoundException(parameter);
        }
    }

    @Override
    public void setParameterValue(String parameter, String value) throws ParameterException {
        if (!StringUtil.isNumeric((String)value)) {
            throw new InvalidParameterException(parameter, value);
        }
        this.setParameterValue(parameter, Float.parseFloat(value));
    }

    @Override
    public String getParameterValue(String parameter) throws ParameterException {
        return "" + this.getFloatParameterValue(parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloatParameterValue(String parameter) throws ParameterException {
        if (parameter.equals("volume")) {
            Object object = this.clipLock;
            synchronized (object) {
                if (this.outputLine != null) {
                    FloatControl volume = (FloatControl)this.outputLine.getControl(FloatControl.Type.MASTER_GAIN);
                    return volume.getValue();
                }
                logger.warn("Attempting to get parameter: {} on null output line!", (Object)parameter);
                return this.desiredVolume;
            }
        }
        throw new ParameterNotFoundException(parameter);
    }

    private void setPlaying(boolean play) {
        this.playing = play;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.stop = true;
        this.playing = false;
        logger.debug("WavUnit stop");
        Object object = this.clipLock;
        synchronized (object) {
            if (this.outputLine != null) {
                logger.debug("Stop output line");
                this.outputLine.stop();
                new OutputLineCloseThread(this.outputLine).start();
                this.outputLine = null;
            }
        }
    }

    @Override
    public void start(double relTime) {
        this.setPlaying(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play(double relTime) throws WavUnitPlayException {
        if (this.stop) {
            return;
        }
        Object object = this.clipLock;
        synchronized (object) {
            if (this.outputLine == null) {
                DataLine.Info info = new DataLine.Info(Clip.class, this.audioFormat);
                if (!AudioSystem.isLineSupported(info)) {
                    throw new WavUnitPlayException("AudioSystem line unsupported for " + info.toString(), this);
                }
                try {
                    this.outputLine = (Clip)AudioSystem.getLine(info);
                    this.outputLine.open(this.audioFormat, this.audioData, 0, this.audioData.length);
                    this.setVolume(this.desiredVolume);
                }
                catch (LineUnavailableException ex) {
                    throw new WavUnitPlayException(ex.getLocalizedMessage(), this, ex);
                }
                this.outputLine.setMicrosecondPosition((long)(relTime * 1000000.0));
                this.outputLine.start();
                this.firstPlay = true;
            } else if (Math.abs((double)this.outputLine.getMicrosecondPosition() * 1.0E-6 - relTime) > 0.066 || this.firstPlay) {
                this.firstPlay = false;
            }
        }
    }

    private static class OutputLineCloseThread
    extends Thread {
        private Clip outputLine;

        public OutputLineCloseThread(Clip outputLine) {
            this.outputLine = outputLine;
        }

        @Override
        public void run() {
            this.outputLine.close();
        }
    }
}

