/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.elckerlyc.audioengine.SoundManager;
import hmi.elckerlyc.audioengine.WavLWJGLJoalUnit;
import hmi.elckerlyc.audioengine.WavUnit;
import hmi.elckerlyc.audioengine.WavUnitPlanningException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;

public class LWJGLJoalSoundManager
implements SoundManager {
    private Map<String, IntBuffer> sourceMap = new HashMap<String, IntBuffer>();

    @Override
    public void init() {
        try {
            AL.create(null, (int)15, (int)22050, (boolean)true);
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public WavUnit createWavUnit(InputStream inputStream, String sourceId) throws WavUnitPlanningException {
        IntBuffer source = this.sourceMap.get(sourceId);
        if (source == null) {
            source = BufferUtils.createIntBuffer((int)1);
            AL10.alGenSources((IntBuffer)source);
            this.sourceMap.put(sourceId, source);
        }
        return new WavLWJGLJoalUnit(inputStream, source.get(0));
    }

    @Override
    public WavUnit createWavUnit(InputStream inputStream) throws WavUnitPlanningException {
        return new WavLWJGLJoalUnit(inputStream);
    }

    @Override
    public void shutdown() {
        for (IntBuffer source : this.sourceMap.values()) {
            AL10.alDeleteSources((IntBuffer)source);
        }
        AL.destroy();
    }
}

