/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.bml.core.Behaviour;
import hmi.bml.ext.bmlt.BMLTAudioFileBehaviour;
import hmi.elckerlyc.AbstractPlanner;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.audioengine.AudioUnitPlanningException;
import hmi.elckerlyc.audioengine.SoundManager;
import hmi.elckerlyc.audioengine.TimedAbstractAudioUnit;
import hmi.elckerlyc.audioengine.TimedWavAudioUnit;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import hmi.util.Resources;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioPlanner
extends AbstractPlanner {
    private Resources audioResource;
    private static Logger logger = LoggerFactory.getLogger((String)AudioPlanner.class.getName());
    private final SoundManager soundManager;
    private static final double TIMEPEG_TOLERANCE = 0.003;

    public AudioPlanner(FeedbackManager bfm, Resources audioRes, PlanManager planManager, SoundManager soundManager) {
        super(bfm, planManager);
        this.audioResource = audioRes;
        this.soundManager = soundManager;
    }

    private TimedAbstractAudioUnit createAudioUnit(BMLBlockPeg bbPeg, Behaviour b) throws BehaviourPlanningException {
        BMLTAudioFileBehaviour bAudio = (BMLTAudioFileBehaviour)b;
        TimedWavAudioUnit au = new TimedWavAudioUnit(this.soundManager, this.fbManager, bbPeg, this.audioResource.getInputStream(bAudio.getStringParameterValue("fileName")), bAudio.getBmlId(), bAudio.id);
        try {
            au.setup();
        }
        catch (AudioUnitPlanningException e) {
            throw new BehaviourPlanningException(b, e.getLocalizedMessage(), e);
        }
        logger.debug("Creating audio unit {} duration: {}", (Object)b.id, (Object)au.getPreferedDuration());
        return au;
    }

    @Override
    public List<SyncAndTimePeg> addBehaviour(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sacs, TimedPlanUnit planElement) throws BehaviourPlanningException {
        this.validateSyncs(sacs, b);
        ArrayList<SyncAndTimePeg> satp = new ArrayList<SyncAndTimePeg>();
        TimedAbstractAudioUnit au = planElement == null ? this.createAudioUnit(bbPeg, b) : (TimedAbstractAudioUnit)planElement;
        this.linkStartAndEnd(b, sacs, au);
        satp.add(new SyncAndTimePeg(b.getBmlId(), b.id, "start", au.getStartPeg()));
        if (au.getEndPeg() != null) {
            satp.add(new SyncAndTimePeg(b.getBmlId(), b.id, "end", au.getEndPeg()));
        }
        this.planManager.addPlanUnit(au);
        return satp;
    }

    private void linkStartAndEnd(Behaviour b, List<TimePegAndConstraint> sacs, TimedAbstractAudioUnit au) {
        for (TimePegAndConstraint sac : sacs) {
            OffsetPeg p;
            if (sac.syncId.equals("start")) {
                if (sac.offset == 0.0) {
                    au.setStart(sac.peg);
                } else {
                    p = new OffsetPeg(sac.peg, -sac.offset);
                    au.setStart(p);
                }
            }
            if (!sac.syncId.equals("end")) continue;
            if (sac.offset == 0.0) {
                au.setEnd(sac.peg);
                continue;
            }
            p = new OffsetPeg(sac.peg, -sac.offset);
            au.setEnd(p);
        }
    }

    private void validateSyncs(List<TimePegAndConstraint> sacs, Behaviour b) throws BehaviourPlanningException {
        for (TimePegAndConstraint sac : sacs) {
            if (sac.syncId.equals("start") || sac.syncId.equals("end")) continue;
            throw new BehaviourPlanningException(b, "Attempting to synchronize a audiofile behaviour with sync: " + sac.syncId + " other than start or end");
        }
    }

    @Override
    public TimedPlanUnit resolveSynchs(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sacs) throws BehaviourPlanningException {
        TimedAbstractAudioUnit au = this.createAudioUnit(bbPeg, b);
        double startTime = bbPeg.getValue();
        boolean startFound = false;
        this.validateSyncs(sacs, b);
        for (TimePegAndConstraint sac : sacs) {
            if (!sac.syncId.equals("start") || sac.peg.getGlobalValue() == -1.7976931348623157E308) continue;
            startTime = sac.peg.getGlobalValue() - sac.offset;
            startFound = true;
        }
        if (!startFound) {
            for (TimePegAndConstraint sac : sacs) {
                if (sac.peg.getGlobalValue() == -1.7976931348623157E308 || !sac.syncId.equals("end") || sac.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                startTime = sac.peg.getGlobalValue() - au.getPreferedDuration() - sac.offset;
                break;
            }
        }
        TimePegAndConstraint sacNotStart = null;
        for (TimePegAndConstraint sac : sacs) {
            if (sac.syncId.equals("start")) continue;
            sacNotStart = sac;
            break;
        }
        for (TimePegAndConstraint sac : sacs) {
            if (sac.syncId.equals("end")) {
                if (sac.peg.getGlobalValue() == -1.7976931348623157E308) {
                    sac.peg.setGlobalValue(au.getPreferedDuration() + startTime + sac.offset);
                } else if (Math.abs(sac.peg.getGlobalValue() - (startTime + au.getPreferedDuration() + sac.offset)) > 0.003) {
                    throw new BehaviourPlanningException(b, "Stretching audio fragments is not supported yet. Should not be too hard to do, though. Behavior omitted.");
                }
            }
            if (!sac.syncId.equals("start") || sac.peg.getGlobalValue() != -1.7976931348623157E308) continue;
            if (sac.resolveAsStartOffset) {
                OffsetPeg p = (OffsetPeg)sac.peg;
                p.setLink(sacNotStart.peg);
                p.setOffset(startTime - sacNotStart.peg.getGlobalValue());
                continue;
            }
            sac.peg.setGlobalValue(startTime + sac.offset);
        }
        this.linkStartAndEnd(b, sacs, au);
        return au;
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedBehaviours() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(BMLTAudioFileBehaviour.class);
        return list;
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedDescriptionExtensions() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(BMLTAudioFileBehaviour.class);
        return list;
    }

    @Override
    public double getRigidity(Behaviour beh) {
        return 1.0;
    }
}

