/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.noise;

import hmi.animation.VJoint;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.KeyPositionManager;
import hmi.elckerlyc.animationengine.KeyPositionManagerImpl;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.animationengine.noise.NoiseMU;
import hmi.elckerlyc.animationengine.noise.NoiseTMU;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.math.PerlinNoise;
import hmi.math.Quat4f;
import java.util.HashMap;
import java.util.List;

public class PerlinNoiseMU
implements NoiseMU {
    private HashMap<String, String> parameters = new HashMap();
    private KeyPositionManager keyPositionManager = new KeyPositionManagerImpl();
    private PerlinNoise pnx1 = new PerlinNoise(1024, 0.0f, 1.0f);
    private PerlinNoise pny1 = new PerlinNoise(1024, 0.0f, 1.0f);
    private PerlinNoise pnz1 = new PerlinNoise(1024, 0.0f, 1.0f);
    protected AnimationPlayer player;
    float[] q = new float[4];

    @Override
    public void addKeyPosition(KeyPosition kp) {
        this.keyPositionManager.addKeyPosition(kp);
    }

    @Override
    public List<KeyPosition> getKeyPositions() {
        return this.keyPositionManager.getKeyPositions();
    }

    @Override
    public void setKeyPositions(List<KeyPosition> p) {
        this.keyPositionManager.setKeyPositions(p);
    }

    @Override
    public void removeKeyPosition(String id) {
        this.keyPositionManager.removeKeyPosition(id);
    }

    @Override
    public KeyPosition getKeyPosition(String name) {
        return this.keyPositionManager.getKeyPosition(name);
    }

    public PerlinNoiseMU() {
        this.setParameterValue("joint", "skullbase");
        this.setFloatParameterValue("offsetx", -0.1f);
        this.setFloatParameterValue("offsety", 0.0f);
        this.setFloatParameterValue("offsetz", 0.0f);
        this.setFloatParameterValue("basefreqx", 1.0f);
        this.setFloatParameterValue("basefreqy", 1.0f);
        this.setFloatParameterValue("basefreqz", 1.0f);
        this.setFloatParameterValue("baseamplitudex", 0.5f);
        this.setFloatParameterValue("baseamplitudey", 0.0f);
        this.setFloatParameterValue("baseamplitudez", 0.0f);
        this.setFloatParameterValue("persistencex", 0.5f);
        this.setFloatParameterValue("persistencey", 0.5f);
        this.setFloatParameterValue("persistencez", 0.5f);
    }

    @Override
    public double getPreferedDuration() {
        return 1.0;
    }

    @Override
    public void play(double t) throws MUPlayException {
        try {
            float rotxRad = this.getFloatParameterValue("offsetx") + this.getFloatParameterValue("baseamplitudex") * this.pnx1.noise((float)t * this.getFloatParameterValue("basefreqx"));
            float rotyRad = this.getFloatParameterValue("offsety") + this.getFloatParameterValue("baseamplitudey") * this.pny1.noise((float)t * this.getFloatParameterValue("basefreqy"));
            float rotzRad = this.getFloatParameterValue("offsetz") + this.getFloatParameterValue("baseamplitudez") * this.pnz1.noise((float)t * this.getFloatParameterValue("basefreqz"));
            Quat4f.setFromRollPitchYaw((float[])this.q, (float)rotzRad, (float)rotxRad, (float)rotyRad);
            this.player.getVNext().getPart(this.getParameterValue("joint")).setRotation(this.q);
        }
        catch (Exception ex) {
            throw new MUPlayException(ex.getMessage(), this);
        }
    }

    @Override
    public MotionUnit getPredictor(VJoint predict) {
        return null;
    }

    @Override
    public void setFloatParameterValue(String name, float value) {
        this.parameters.put(name, "" + value);
    }

    @Override
    public void setParameterValue(String name, String value) {
        this.parameters.put(name, value);
    }

    @Override
    public String getParameterValue(String name) throws ParameterNotFoundException {
        if (this.parameters.get(name) == null) {
            throw new ParameterNotFoundException(name);
        }
        return this.parameters.get(name);
    }

    @Override
    public float getFloatParameterValue(String name) throws ParameterNotFoundException {
        if (this.parameters.get(name) == null) {
            throw new ParameterNotFoundException(name);
        }
        float value = 0.0f;
        try {
            value = Float.parseFloat(this.parameters.get(name));
        }
        catch (NumberFormatException ex) {
            throw new ParameterNotFoundException(name);
        }
        return value;
    }

    @Override
    public TimedMotionUnit createTMU(FeedbackManager bbm, BMLBlockPeg bbPeg, String bmlId, String id) {
        return new NoiseTMU(bbm, bbPeg, bmlId, id, this);
    }

    @Override
    public MotionUnit copy(AnimationPlayer p) {
        HashMap<String, String> newparam = new HashMap<String, String>();
        newparam.putAll(this.parameters);
        PerlinNoiseMU pmu = new PerlinNoiseMU();
        pmu.parameters = newparam;
        pmu.player = p;
        return pmu;
    }

    @Override
    public String getReplacementGroup() {
        try {
            return this.getParameterValue("replacementgroup");
        }
        catch (ParameterNotFoundException e) {
            return null;
        }
    }
}

