/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.noise;

import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.TMUPlayException;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.animationengine.noise.NoiseMU;
import hmi.elckerlyc.feedback.FeedbackManager;

public class NoiseTMU
extends TimedMotionUnit {
    private NoiseMU nmu;

    public NoiseTMU(FeedbackManager bfm, BMLBlockPeg bmlBlockPeg, String bmlId, String id, NoiseMU nmu) {
        super(bfm, bmlBlockPeg, bmlId, id, nmu);
        this.nmu = nmu;
    }

    @Override
    protected void startUnit(double time) throws TimedPlanUnitPlayException {
        this.sendProgress(0.0, time);
    }

    @Override
    protected void playUnit(double time) throws TMUPlayException {
        try {
            this.nmu.play(time);
        }
        catch (MUPlayException ex) {
            throw new TMUPlayException(ex.getLocalizedMessage(), this, (Exception)ex);
        }
    }

    @Override
    public void stopUnit(double time) {
        this.sendProgress(1.0, time);
    }

    private void sendProgress(double t, double time) {
        for (KeyPosition k : this.nmu.getKeyPositions()) {
            if (!(k.time <= t) || this.progressHandled.contains(k)) continue;
            String bmlId = this.getBMLId();
            String behaviorId = this.getId();
            String syncId = k.id;
            double bmlBlockTime = time - this.bmlBlockPeg.getValue();
            this.feedback(new BMLSyncPointProgressFeedback(bmlId, behaviorId, syncId, bmlBlockTime, time));
            this.progressHandled.add(k);
        }
    }
}

