/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.motionunit;

import hmi.animation.VJoint;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.SyncPointNotFoundException;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TMUPlayException;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.feedback.NullFeedbackManager;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.elckerlyc.planunit.PlanUnitFloatParameterNotFoundException;
import hmi.elckerlyc.planunit.PlanUnitParameterNotFoundException;
import hmi.elckerlyc.planunit.PlanUnitTimeManager;
import hmi.elckerlyc.planunit.TimedAbstractPlanUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TimedMotionUnit
extends TimedAbstractPlanUnit {
    private final MotionUnit mu;
    protected ArrayList<KeyPosition> progressHandled = new ArrayList();
    private final PlanUnitTimeManager puTimeManager;

    public TimedMotionUnit(FeedbackManager bbf, BMLBlockPeg bmlBlockPeg, String bmlId, String id, MotionUnit m) {
        super(bbf, bmlBlockPeg, bmlId, id);
        this.mu = m;
        this.puTimeManager = new PlanUnitTimeManager(this.mu);
    }

    public TimedMotionUnit(BMLBlockPeg bmlBlockPeg, String bmlId, String id, MotionUnit m) {
        this((FeedbackManager)NullFeedbackManager.getInstance(), bmlBlockPeg, bmlId, id, m);
    }

    public TimedMotionUnit getPredictor(VJoint vPredict) {
        MotionUnit muPred = this.mu.getPredictor(vPredict);
        if (muPred != null) {
            TimedMotionUnit copy = muPred.createTMU(NullFeedbackManager.getInstance(), this.getBMLBlockPeg(), this.getBMLId(), this.getId() + "-pred");
            copy.setState(this.getState());
            copy.puTimeManager.setPegs(this.puTimeManager.getPegs());
            return copy;
        }
        return null;
    }

    public KeyPosition getKeyPosition(String kid) {
        return this.getMotionUnit().getKeyPosition(kid);
    }

    private void sendProgress(double t, double time) {
        for (KeyPosition k : this.mu.getKeyPositions()) {
            if (!(k.time <= t) || this.progressHandled.contains(k)) continue;
            String bmlId = this.getBMLId();
            String behaviorId = this.getId();
            String syncId = k.id;
            double bmlBlockTime = time - this.bmlBlockPeg.getValue();
            this.feedback(new BMLSyncPointProgressFeedback(bmlId, behaviorId, syncId, bmlBlockTime, time));
            this.progressHandled.add(k);
        }
    }

    @Override
    protected void playUnit(double time) throws TMUPlayException {
        double t = this.puTimeManager.getRelativeTime(time);
        try {
            this.mu.play(t);
        }
        catch (MUPlayException ex) {
            throw new TMUPlayException(ex.getLocalizedMessage(), this, (Exception)ex);
        }
        this.sendProgress(t, time);
    }

    @Override
    public void stopUnit(double time) {
        if (time < this.getEndTime()) {
            this.sendProgress(this.puTimeManager.getRelativeTime(time), time);
        } else {
            this.sendProgress(1.0, time);
        }
    }

    public MotionUnit getMotionUnit() {
        return this.mu;
    }

    @Override
    public String getReplacementGroup() {
        return this.mu.getReplacementGroup();
    }

    @Override
    public double getPreferedDuration() {
        return this.mu.getPreferedDuration();
    }

    @Override
    public void setParameterValue(String paramId, String value) throws ParameterException {
        try {
            this.mu.setParameterValue(paramId, value);
        }
        catch (ParameterNotFoundException e) {
            throw new PlanUnitParameterNotFoundException(this.getBMLId(), this.getId(), e.getParamId(), e);
        }
    }

    @Override
    public void setFloatParameterValue(String paramId, float value) throws ParameterException {
        try {
            this.mu.setFloatParameterValue(paramId, value);
        }
        catch (ParameterNotFoundException e) {
            throw new PlanUnitFloatParameterNotFoundException(this.getBMLId(), this.getId(), e.getParamId(), e);
        }
    }

    @Override
    public float getFloatParameterValue(String paramId) throws ParameterException {
        try {
            return this.mu.getFloatParameterValue(paramId);
        }
        catch (ParameterNotFoundException e) {
            throw new PlanUnitFloatParameterNotFoundException(this.getBMLId(), this.getId(), e.getParamId(), e);
        }
    }

    @Override
    public String getParameterValue(String paramId) throws ParameterException {
        try {
            return this.mu.getParameterValue(paramId);
        }
        catch (ParameterNotFoundException e) {
            throw new PlanUnitParameterNotFoundException(this.getBMLId(), this.getId(), e.getParamId(), e);
        }
    }

    public void setPegs(Map<KeyPosition, TimePeg> pegs) {
        this.puTimeManager.setPegs(pegs);
    }

    @Override
    public double getRelativeTime(String syncId) throws SyncPointNotFoundException {
        return this.puTimeManager.getRelativeTime(syncId);
    }

    public Map<KeyPosition, TimePeg> getPegs() {
        return this.puTimeManager.getPegs();
    }

    @Override
    public boolean hasValidTiming() {
        return this.puTimeManager.hasValidTiming();
    }

    public KeyPosition getKeyPosition(TimePeg sp) {
        return this.puTimeManager.getKeyPosition(sp);
    }

    public double getPrevPegTime(String pid) {
        return this.puTimeManager.getPrevPegTime(pid);
    }

    public double getNextPegTime(String pid) {
        return this.puTimeManager.getNextPegTime(pid);
    }

    @Override
    public double getTime(String pid) {
        return this.puTimeManager.getTime(pid);
    }

    @Override
    public TimePeg getTimePeg(String pid) {
        return this.puTimeManager.getTimePeg(pid);
    }

    @Override
    public double getStartTime() {
        return this.puTimeManager.getStartTime();
    }

    @Override
    public double getEndTime() {
        return this.puTimeManager.getEndTime();
    }

    @Override
    public double getRelaxTime() {
        return this.puTimeManager.getRelaxTime();
    }

    public void setTimePeg(KeyPosition kp, TimePeg sp) {
        this.puTimeManager.setTimePeg(kp, sp);
    }

    @Override
    public void setTimePeg(String kid, TimePeg sp) {
        this.puTimeManager.setTimePeg(kid, sp);
    }

    public void resolveDefaultBMLKeyPositions() {
        this.puTimeManager.resolveDefaultBMLKeyPositions();
    }

    public double getRelativeTime(double absoluteTime) {
        return this.puTimeManager.getRelativeTime(absoluteTime);
    }

    @Override
    public List<String> getAvailableSyncs() {
        return this.puTimeManager.getAvailableSyncs();
    }
}

