/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.gesturebinding;

import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.gesturebinding.MotionUnitParameterDefault;
import hmi.elckerlyc.animationengine.gesturebinding.VisimeSpec;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.feedback.NullFeedbackManager;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.util.Resources;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeechBinding
extends XMLStructureAdapter {
    private Map<Integer, VisimeSpec> specs = new HashMap<Integer, VisimeSpec>();
    private static final Logger logger = LoggerFactory.getLogger((String)SpeechBinding.class.getName());
    private final Resources resources;
    private static final String XMLTAG = "speechbinding";

    public SpeechBinding(Resources r) {
        this.resources = r;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (!tag.equals(VisimeSpec.xmlTag())) continue;
            VisimeSpec viSpec = new VisimeSpec(this.resources);
            viSpec.readXML(tokenizer);
            if (viSpec.getMotionUnit() != null) {
                this.specs.put(viSpec.getVisime(), viSpec);
                continue;
            }
            logger.warn("Dropped motion unit spec because we could not construct the motion unit");
        }
    }

    public TimedMotionUnit getMotionUnit(int visime, BMLBlockPeg bbPeg, String bmlId, String id, AnimationPlayer player) {
        return this.getMotionUnit(NullFeedbackManager.getInstance(), visime, bbPeg, bmlId, id, player);
    }

    public TimedMotionUnit getMotionUnit(FeedbackManager fbm, int visime, BMLBlockPeg bbPeg, String bmlId, String id, AnimationPlayer player) {
        VisimeSpec viSpec = this.specs.get(visime);
        if (viSpec != null) {
            MotionUnit mu = viSpec.getMotionUnit();
            MotionUnit muCopy = mu.copy(player);
            TimedMotionUnit tmu = muCopy.createTMU(fbm, bbPeg, bmlId, id);
            for (MotionUnitParameterDefault mupc : viSpec.getParameterDefaults()) {
                try {
                    muCopy.setParameterValue(mupc.name, mupc.value);
                }
                catch (ParameterException e) {
                    logger.warn("ParameterException in " + mu, (Throwable)e);
                    return null;
                }
                logger.debug("Setting parameter {}  to default {}", (Object)mupc.name, (Object)mupc.value);
            }
            return tmu;
        }
        return null;
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

