/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.gaze;

import hmi.animation.VJoint;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.gaze.GazeMU;
import hmi.elckerlyc.animationengine.gaze.GazeTMU;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.neurophysics.EyeSaturation;
import hmi.neurophysics.ListingsLaw;
import hmi.neurophysics.Saccade;

public class EyeGazeMU
extends GazeMU {
    private float[] qEyeLeft = Quat4f.getQuat4f();
    private float[] qEyeRight = Quat4f.getQuat4f();

    @Override
    public EyeGazeMU copy(AnimationPlayer p) {
        EyeGazeMU gmu = new EyeGazeMU();
        gmu.lEye = p.getVNext().getPart("l_eyeball_joint");
        gmu.rEye = p.getVNext().getPart("r_eyeball_joint");
        gmu.player = p;
        gmu.woManager = p.getWoManager();
        gmu.target = this.target;
        gmu.offsetAngle = this.offsetAngle;
        gmu.offsetDirection = this.offsetDirection;
        return gmu;
    }

    @Override
    public TimedMotionUnit createTMU(FeedbackManager bfm, BMLBlockPeg bmlBlockPeg, String bmlId, String id) {
        return new GazeTMU(bfm, bmlBlockPeg, bmlId, id, this);
    }

    @Override
    void setEndRotation(float[] gazeDir) throws MUPlayException {
        this.woTarget = this.woManager.getWorldObject(this.target);
        if (this.woTarget == null) {
            throw new MUPlayException("Gaze target not found", this);
        }
        this.woTarget.getTranslation2(gazeDir, this.rEye);
        Quat4f.transformVec3f((float[])this.getOffsetRotation(), (float[])gazeDir);
        Vec3f.normalize((float[])gazeDir);
        float[] q = Quat4f.getQuat4f();
        ListingsLaw.listingsEye((float[])gazeDir, (float[])q);
        EyeSaturation.sat((float[])q, (float[])Quat4f.getIdentity(), (float[])this.qEyeRight);
        this.woTarget.getTranslation2(gazeDir, this.lEye);
        Quat4f.transformVec3f((float[])this.getOffsetRotation(), (float[])gazeDir);
        Vec3f.normalize((float[])gazeDir);
        ListingsLaw.listingsEye((float[])gazeDir, (float[])q);
        EyeSaturation.sat((float[])q, (float[])Quat4f.getIdentity(), (float[])this.qEyeLeft);
    }

    @Override
    public double getReadyDuration() {
        float[] q = Quat4f.getQuat4f();
        Quat4f.mulConjugateRight((float[])q, (float[])this.qStartLeftEye, (float[])this.qEyeLeft);
        float angle = Quat4f.getAngle((float[])q);
        if (angle < 0.0f) {
            angle = -angle;
        }
        if ((double)angle > Math.PI) {
            angle = (float)((double)angle - Math.PI);
        }
        return Saccade.getSaccadeDuration((double)angle);
    }

    @Override
    public void play(double t) throws MUPlayException {
        float[] qLeft = Quat4f.getQuat4f();
        float[] qRight = Quat4f.getQuat4f();
        if (t < 0.25) {
            Quat4f.interpolate((float[])qLeft, (float[])this.qStartLeftEye, (float[])this.qEyeLeft, (float)((float)t / 0.25f));
            Quat4f.interpolate((float[])qRight, (float[])this.qStartRightEye, (float[])this.qEyeRight, (float)((float)t / 0.25f));
        } else if (t > 0.75) {
            Quat4f.interpolate((float[])qLeft, (float[])this.qStartLeftEye, (float[])this.qEyeLeft, (float)((float)(1.0 - t) / 0.25f));
            Quat4f.interpolate((float[])qRight, (float[])this.qStartRightEye, (float[])this.qEyeRight, (float)((float)(1.0 - t) / 0.25f));
        } else {
            Quat4f.set((float[])qLeft, (float[])this.qEyeLeft);
            Quat4f.set((float[])qRight, (float[])this.qEyeRight);
        }
        this.rEye.setRotation(qRight);
        this.lEye.setRotation(qLeft);
    }

    @Override
    public MotionUnit getPredictor(VJoint vPredict) {
        EyeGazeMU predictor = this.copy(this.player);
        predictor.lEye = vPredict.getPart("l_eyeball_joint");
        predictor.rEye = vPredict.getPart("r_eyeball_joint");
        Quat4f.set((float[])predictor.qStart, (float[])Quat4f.getIdentity());
        Quat4f.set((float[])predictor.qStartLeftEye, (float[])this.qStartLeftEye);
        Quat4f.set((float[])predictor.qStartRightEye, (float[])this.qStartRightEye);
        return predictor;
    }
}

