/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.activate;

import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.TimedAbstractPlanUnit;
import hmi.elckerlyc.scheduler.BMLScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedActivateUnit
extends TimedAbstractPlanUnit {
    private TimePeg startPeg;
    private final BMLScheduler scheduler;
    private final String target;
    private static final Logger logger = LoggerFactory.getLogger((String)TimedActivateUnit.class.getName());

    public TimedActivateUnit(FeedbackManager bfm, BMLBlockPeg bmlPeg, String bmlId, String id, String target, BMLScheduler s) {
        super(bfm, bmlPeg, bmlId, id);
        this.scheduler = s;
        this.target = target;
        logger.debug("Created activate unit {} {} {}", (Object[])new String[]{this.getBMLId(), this.getId(), target});
    }

    @Override
    protected void startUnit(double time) throws TimedPlanUnitPlayException {
        logger.debug("starting activate unit {} {}", (Object)this.getBMLId(), (Object)this.getId());
        this.scheduler.activateBlock(this.target, time);
        this.sendFeedback("start", time);
        this.sendFeedback("ready", time);
        this.sendFeedback("stroke-start", time);
        this.sendFeedback("stroke", time);
    }

    public void setStartPeg(TimePeg startPeg) {
        this.startPeg = startPeg;
        logger.debug("Setting start peg to {}", (Object)startPeg);
    }

    @Override
    protected void playUnit(double time) throws TimedPlanUnitPlayException {
        this.stop(time);
    }

    @Override
    protected void stopUnit(double time) throws TimedPlanUnitPlayException {
        logger.debug("stopping activate unit {} {}", (Object)this.getBMLId(), (Object)this.getId());
        this.sendFeedback("stroke-end", time);
        this.sendFeedback("relax", time);
        this.sendFeedback("end", time);
    }

    @Override
    public double getEndTime() {
        return -1.7976931348623157E308;
    }

    @Override
    public double getRelaxTime() {
        return this.getEndTime();
    }

    @Override
    public double getStartTime() {
        return this.startPeg.getGlobalValue();
    }

    @Override
    public boolean hasValidTiming() {
        return true;
    }

    @Override
    public TimePeg getTimePeg(String syncId) {
        if (syncId.equals("start")) {
            return this.startPeg;
        }
        return null;
    }

    @Override
    public void setTimePeg(String syncId, TimePeg peg) {
        if (syncId.equals("start")) {
            this.startPeg = peg;
        } else {
            logger.warn("Can't set TimePeg for sync {}, only setting start is allowed", (Object)syncId);
        }
    }
}

