/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.bml.BMLSync;
import hmi.bml.core.Behaviour;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.SyncPointNotFoundException;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.speechengine.SpeechUnitPlanningException;
import hmi.elckerlyc.speechengine.TimedAbstractSpeechUnit;
import hmi.elckerlyc.speechengine.ttsbinding.TTSBinding;
import hmi.tts.Bookmark;
import hmi.tts.TimingInfo;
import hmi.tts.Visime;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimedTTSUnit
extends TimedAbstractSpeechUnit {
    protected TTSBinding ttsBinding;
    private double duration;
    protected List<Bookmark> bookmarks;
    protected List<Visime> visimes;
    public int prevVisime;
    public int curVisime;
    public int nextVisime;
    public double visimeDuration;
    private final Class<? extends Behaviour> behaviourClass;
    protected TreeMap<Bookmark, TimePeg> pegs = new TreeMap();
    private static Logger logger = LoggerFactory.getLogger((String)TimedTTSUnit.class.getName());

    public Class<? extends Behaviour> getBehaviourClass() {
        return this.behaviourClass;
    }

    public TimedTTSUnit(FeedbackManager bfm, BMLBlockPeg bbPeg, String text, String bmlId, String id, TTSBinding ttsBin, Class<? extends Behaviour> behClass) {
        super(bfm, bbPeg, text, bmlId, id);
        this.ttsBinding = ttsBin;
        this.bookmarks = new ArrayList<Bookmark>();
        this.visimes = new ArrayList<Visime>();
        this.behaviourClass = behClass;
    }

    public TimePeg getBookMarkTimePeg(String bmid) {
        for (Bookmark b : this.bookmarks) {
            if (!b.getName().equals(bmid) || this.pegs.get(b) == null) continue;
            return this.pegs.get(b);
        }
        return null;
    }

    public double getBookMarkTime(Bookmark b) {
        TimePeg p = this.pegs.get(b);
        if (p == null) {
            return -1.7976931348623157E308;
        }
        return p.getGlobalValue();
    }

    public TimePeg getBookMarkTimePeg(Bookmark b) {
        if (this.pegs.get(b) != null) {
            return this.pegs.get(b);
        }
        return null;
    }

    private double getBookMarkTime(String bmid) {
        for (Bookmark b : this.bookmarks) {
            if (!b.getName().equals(bmid) || this.pegs.get(b) == null) continue;
            return this.pegs.get(b).getGlobalValue();
        }
        return -1.7976931348623157E308;
    }

    private Bookmark getBookMark(String syncId) {
        for (Bookmark b : this.bookmarks) {
            if (!b.getName().equals(syncId)) continue;
            return b;
        }
        return null;
    }

    @Override
    public double getTime(String syncId) {
        if (this.getBookMarkTime(syncId) != -1.7976931348623157E308) {
            return this.getBookMarkTime(syncId);
        }
        return super.getTime(syncId);
    }

    @Override
    public TimePeg getTimePeg(String syncId) {
        if (this.getBookMarkTimePeg(syncId) != null) {
            return this.getBookMarkTimePeg(syncId);
        }
        if (syncId.equals("start")) {
            return this.getStartPeg();
        }
        if (syncId.equals("end")) {
            return this.getEndPeg();
        }
        return null;
    }

    @Override
    public void setTimePeg(String syncId, TimePeg peg) {
        if (this.getBookMark(syncId) != null) {
            this.setTimePeg(this.getBookMark(syncId), peg);
        }
        if (BMLSync.isBMLSync((String)syncId)) {
            if (BMLSync.get((String)syncId).isAfter(BMLSync.STROKE)) {
                this.setEnd(peg);
            } else {
                this.setStart(peg);
            }
        } else {
            logger.warn("Can't set TimePeg on non-BML, non-Bookmark sync {}", (Object)syncId);
        }
    }

    @Override
    public double getRelativeTime(String syncId) throws SyncPointNotFoundException {
        if (this.getBookMarkTime(syncId) != -1.7976931348623157E308) {
            return (this.getBookMarkTime(syncId) - this.getStartTime()) / this.getPreferedDuration();
        }
        return super.getRelativeTime(syncId);
    }

    @Override
    public List<String> getAvailableSyncs() {
        ArrayList<String> availableSyncs = new ArrayList<String>();
        availableSyncs.add(BMLSync.START.getId());
        availableSyncs.add(BMLSync.READY.getId());
        availableSyncs.add(BMLSync.STROKE_START.getId());
        availableSyncs.add(BMLSync.STROKE.getId());
        for (Bookmark b : this.getBookmarks()) {
            availableSyncs.add(b.getName());
        }
        availableSyncs.add(BMLSync.STROKE_END.getId());
        availableSyncs.add(BMLSync.RELAX.getId());
        availableSyncs.add(BMLSync.END.getId());
        return availableSyncs;
    }

    @Override
    public boolean hasValidTiming() {
        if (this.getStartTime() > this.getEndTime()) {
            return false;
        }
        if (Math.abs(this.getEndTime() - this.getStartTime() - this.getPreferedDuration()) > 1.0E-4) {
            logger.debug("End time: {}", (Object)this.getEndTime());
            logger.debug("Start time: ", (Object)this.getStartTime());
            logger.debug("End-start: ", (Object)(this.getEndTime() - this.getStartTime()));
            logger.debug("Duration: ", (Object)this.getPreferedDuration());
            return false;
        }
        for (Bookmark b : this.getBookmarks()) {
            double bmTime = this.getBookMarkTime(b);
            if (bmTime == -1.7976931348623157E308 || !(Math.abs((double)b.getOffset() * 0.001 + this.getStartTime() - bmTime) > 1.0E-4)) continue;
            logger.debug("(b.offset*0.001+getStartTime())= {}", (Object)((double)b.getOffset() * 0.001 + this.getStartTime()));
            logger.debug("bookmarktime= {}", (Object)bmTime);
            return false;
        }
        return true;
    }

    @Override
    public double getPreferedDuration() {
        return this.duration;
    }

    protected abstract TimingInfo getTiming() throws SpeechUnitPlanningException;

    protected void setupCache() throws SpeechUnitPlanningException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setup() throws SpeechUnitPlanningException {
        TTSBinding tTSBinding = this.ttsBinding;
        synchronized (tTSBinding) {
            this.ttsBinding.setCallback(null);
            TimingInfo ti = this.getTiming();
            this.setupCache();
            this.duration = ti.getDuration();
            this.bookmarks.clear();
            this.bookmarks = ti.getBookmarks();
            this.visimes.clear();
            this.visimes = ti.getVisimes();
        }
    }

    protected abstract void sendProgress(double var1, double var3);

    public void setTimePeg(Bookmark bm, TimePeg sp) {
        this.pegs.put(bm, sp);
    }

    public List<Bookmark> getBookmarks() {
        return this.bookmarks;
    }

    public List<Visime> getVisimes() {
        return this.visimes;
    }
}

