/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.TimedAbstractPlanUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimedAbstractSpeechUnit
extends TimedAbstractPlanUnit {
    private TimePeg startSync;
    private TimePeg endSync;
    protected String speechText;
    protected double bmlStartTime;
    private static Logger logger = LoggerFactory.getLogger((String)TimedAbstractSpeechUnit.class.getName());

    TimedAbstractSpeechUnit(FeedbackManager bfm, BMLBlockPeg bbPeg, String text, String bmlId, String id) {
        super(bfm, bbPeg, bmlId, id);
        this.speechText = text;
    }

    @Override
    public double getStartTime() {
        if (this.startSync == null) {
            return -1.7976931348623157E308;
        }
        return this.startSync.getGlobalValue();
    }

    @Override
    public double getEndTime() {
        double startTime;
        double endTime = this.endSync == null ? -1.7976931348623157E308 : this.endSync.getGlobalValue();
        if (endTime == -1.7976931348623157E308 && (startTime = this.getStartTime()) != -1.7976931348623157E308) {
            return startTime + this.getPreferedDuration();
        }
        return endTime;
    }

    public TimePeg getEndPeg() {
        return this.endSync;
    }

    public TimePeg getStartPeg() {
        return this.startSync;
    }

    public void setStart(TimePeg s) {
        this.startSync = s;
    }

    public void setEnd(TimePeg s) {
        this.endSync = s;
    }

    protected void sendStartProgress(double time) {
        logger.debug("Sending start progress feedback.");
        String bmlId = this.getBMLId();
        String behaviorId = this.getId();
        String syncId = "start";
        double bmlBlockTime = time - this.bmlBlockPeg.getValue();
        this.feedback(new BMLSyncPointProgressFeedback(bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "ready";
        this.feedback(new BMLSyncPointProgressFeedback(bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "stroke_start";
        this.feedback(new BMLSyncPointProgressFeedback(bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "stroke";
        this.feedback(new BMLSyncPointProgressFeedback(bmlId, behaviorId, syncId, bmlBlockTime, time));
    }

    public boolean hasSync(String sync) {
        for (String s : this.getAvailableSyncs()) {
            if (!s.equals(sync)) continue;
            return true;
        }
        return false;
    }

    public void sendEndProgress(double time) {
        String bmlId = this.getBMLId();
        String behaviorId = this.getId();
        String syncId = "stroke_end";
        double bmlBlockTime = time - this.bmlBlockPeg.getValue();
        this.feedback(new BMLSyncPointProgressFeedback(bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "relax";
        this.feedback(new BMLSyncPointProgressFeedback(bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "end";
        this.feedback(new BMLSyncPointProgressFeedback(bmlId, behaviorId, syncId, bmlBlockTime, time));
    }
}

