/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.interrupt;

import com.google.common.collect.ImmutableSet;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.TimedAbstractPlanUnit;
import hmi.elckerlyc.scheduler.BMLScheduler;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedInterruptUnit
extends TimedAbstractPlanUnit {
    private static final Logger logger = LoggerFactory.getLogger((String)TimedInterruptUnit.class.getName());
    private TimePeg startPeg;
    private final BMLScheduler scheduler;
    private final String target;
    private ImmutableSet<String> include = new ImmutableSet.Builder().build();
    private ImmutableSet<String> exclude = new ImmutableSet.Builder().build();

    public void setInclude(ImmutableSet<String> include) {
        this.include = include;
    }

    public void setExclude(ImmutableSet<String> exclude) {
        this.exclude = exclude;
    }

    public void setStartPeg(TimePeg startPeg) {
        this.startPeg = startPeg;
        logger.debug("Setting start peg to {}", (Object)startPeg);
    }

    public TimedInterruptUnit(FeedbackManager bfm, BMLBlockPeg bmlPeg, String bmlId, String id, String iTarget, BMLScheduler s) {
        super(bfm, bmlPeg, bmlId, id);
        this.scheduler = s;
        this.target = iTarget;
        logger.debug("Created interrupt unit {} {} {}", (Object[])new String[]{this.getBMLId(), this.getId(), this.target});
    }

    @Override
    protected void startUnit(double time) throws TimedPlanUnitPlayException {
        logger.debug("Starting interrupt unit {} {}", (Object)this.getBMLId(), (Object)this.getId());
        HashSet<String> stopBehs = new HashSet<String>();
        stopBehs.addAll(this.scheduler.getBehaviours(this.target));
        if (this.include.size() > 0) {
            stopBehs.retainAll((Collection<?>)this.include);
        }
        stopBehs.removeAll((Collection<?>)this.exclude);
        for (String beh : stopBehs) {
            logger.debug("Immidiatly interrupting behavior {}:{}", (Object)this.target, (Object)beh);
            this.scheduler.interruptBehavior(this.target, beh);
        }
        this.sendFeedback("start", time);
        this.sendFeedback("ready", time);
        this.sendFeedback("stroke-start", time);
        this.sendFeedback("stroke", time);
    }

    @Override
    protected void playUnit(double time) throws TimedPlanUnitPlayException {
        this.stop(time);
    }

    @Override
    protected void stopUnit(double time) throws TimedPlanUnitPlayException {
        logger.debug("stopping interrupt unit {} {}", (Object)this.getBMLId(), (Object)this.getId());
        this.sendFeedback("stroke-end", time);
        this.sendFeedback("relax", time);
        this.sendFeedback("end", time);
    }

    @Override
    public double getEndTime() {
        return -1.7976931348623157E308;
    }

    @Override
    public double getStartTime() {
        return this.startPeg.getGlobalValue();
    }

    @Override
    public boolean hasValidTiming() {
        return true;
    }

    @Override
    public TimePeg getTimePeg(String syncId) {
        if (syncId.equals("start")) {
            return this.startPeg;
        }
        return null;
    }

    @Override
    public void setTimePeg(String syncId, TimePeg peg) {
        if (syncId.equals("start")) {
            this.startPeg = peg;
        } else {
            logger.warn("Can't set TimePeg for sync {}, only setting start is allowed", (Object)syncId);
        }
    }
}

