/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.feedback;

import com.google.common.collect.ImmutableSet;
import hmi.bml.ext.bmlt.feedback.BMLTSchedulingFinishedFeedback;
import hmi.bml.ext.bmlt.feedback.BMLTSchedulingListener;
import hmi.bml.ext.bmlt.feedback.BMLTSchedulingStartFeedback;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLPerformanceStartFeedback;
import hmi.bml.feedback.BMLPerformanceStopFeedback;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.bml.feedback.BMLWarningFeedback;
import hmi.bml.feedback.BMLWarningListener;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.scheduler.BMLBlockManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedbackManagerImpl
implements FeedbackManager {
    private final BMLBlockManager bmlBlockManager;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)FeedbackManagerImpl.class.getName());
    @GuardedBy(value="feedbackListeners")
    private final List<BMLFeedbackListener> feedbackListeners = Collections.synchronizedList(new ArrayList());
    @GuardedBy(value="exceptionListeners")
    private final List<BMLExceptionListener> exceptionListeners = Collections.synchronizedList(new ArrayList());
    @GuardedBy(value="warningListeners")
    private final List<BMLWarningListener> warningListeners = Collections.synchronizedList(new ArrayList());
    @GuardedBy(value="planningListeners")
    private final List<BMLTSchedulingListener> planningListeners = Collections.synchronizedList(new ArrayList());
    private final String characterId;

    public FeedbackManagerImpl(BMLBlockManager bbm, String characterId) {
        this.bmlBlockManager = bbm;
        this.characterId = characterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exception(BMLExceptionFeedback e) {
        e.setCharacterId(this.characterId);
        List<BMLExceptionListener> list = this.exceptionListeners;
        synchronized (list) {
            for (BMLExceptionListener el : this.exceptionListeners) {
                try {
                    el.exception(e);
                }
                catch (Exception ex) {
                    LOGGER.warn("Broken ExceptionListener: {}", (Throwable)ex);
                }
            }
        }
        this.bmlBlockManager.exception(e);
    }

    @Override
    public void addExceptionListener(BMLExceptionListener es) {
        this.exceptionListeners.add(es);
    }

    @Override
    public void removeAllExceptionListeners() {
        this.exceptionListeners.clear();
    }

    @Override
    public void puException(TimedPlanUnit timedMU, String message, double time) {
        String bmlId = timedMU.getBMLId();
        HashSet<String> failedBehaviours = new HashSet<String>();
        failedBehaviours.add(timedMU.getId());
        HashSet failedConstraints = new HashSet();
        String exceptionText = message + "\nBehavior " + timedMU.getBMLId() + ":" + timedMU.getId() + " dropped.";
        this.exception(new BMLExceptionFeedback(bmlId, time, failedBehaviours, failedConstraints, exceptionText, false));
    }

    @Override
    public void addFeedbackListener(BMLFeedbackListener fb) {
        this.feedbackListeners.add(fb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feedback(BMLSyncPointProgressFeedback fb) {
        fb.setCharacterId(this.characterId);
        List<BMLFeedbackListener> list = this.feedbackListeners;
        synchronized (list) {
            for (BMLFeedbackListener fbl : this.feedbackListeners) {
                try {
                    fbl.syncProgress(fb);
                }
                catch (Exception ex) {
                    LOGGER.warn("Broken FeedbackListener: {}", (Throwable)ex);
                }
            }
        }
        this.bmlBlockManager.syncProgress(fb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feedback(List<BMLSyncPointProgressFeedback> fbs) {
        List<BMLFeedbackListener> list = this.feedbackListeners;
        synchronized (list) {
            for (BMLSyncPointProgressFeedback fb : fbs) {
                fb.setCharacterId(this.characterId);
                for (BMLFeedbackListener fbl : this.feedbackListeners) {
                    try {
                        fbl.syncProgress(fb);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Broken FeedbackListener: {}", (Throwable)ex);
                    }
                }
            }
        }
        for (BMLSyncPointProgressFeedback fb : fbs) {
            this.bmlBlockManager.syncProgress(fb);
        }
    }

    @Override
    public void removeAllFeedbackListeners() {
        this.feedbackListeners.clear();
    }

    @Override
    public ImmutableSet<String> getSyncsPassed(String bmlId, String behaviorId) {
        return this.bmlBlockManager.getSyncsPassed(bmlId, behaviorId);
    }

    @Override
    public void removeFeedbackListener(BMLFeedbackListener fb) {
        this.feedbackListeners.remove(fb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockStopFeedback(BMLPerformanceStopFeedback psf) {
        psf.setCharacterId(this.characterId);
        List<BMLFeedbackListener> list = this.feedbackListeners;
        synchronized (list) {
            for (BMLFeedbackListener fbl : this.feedbackListeners) {
                try {
                    fbl.performanceStop(psf);
                }
                catch (Exception ex) {
                    LOGGER.warn("Broken FeedbackListener: {}", (Throwable)ex);
                }
            }
        }
        this.bmlBlockManager.performanceStop(psf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockStartFeedback(BMLPerformanceStartFeedback psf) {
        psf.setCharacterId(this.characterId);
        List<BMLFeedbackListener> list = this.feedbackListeners;
        synchronized (list) {
            for (BMLFeedbackListener fbl : this.feedbackListeners) {
                try {
                    fbl.performanceStart(psf);
                }
                catch (Exception ex) {
                    LOGGER.warn("Broken FeedbackListener: {}", (Throwable)ex);
                }
            }
        }
        this.bmlBlockManager.performanceStart(psf);
    }

    @Override
    public void removeExceptionListener(BMLExceptionListener e) {
        this.exceptionListeners.remove(e);
    }

    @Override
    public void addPlanningListener(BMLTSchedulingListener p) {
        this.planningListeners.add(p);
    }

    @Override
    public void removeAllPlanningListeners() {
        this.planningListeners.clear();
    }

    @Override
    public void addWarningListener(BMLWarningListener ws) {
        this.warningListeners.add(ws);
    }

    @Override
    public void removeAllWarningListeners() {
        this.warningListeners.clear();
    }

    @Override
    public void removeWarningListener(BMLWarningListener ws) {
        this.warningListeners.remove(ws);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void planningStart(BMLTSchedulingStartFeedback bpsf) {
        List<BMLTSchedulingListener> list = this.planningListeners;
        synchronized (list) {
            for (BMLTSchedulingListener pl : this.planningListeners) {
                try {
                    pl.schedulingStart(bpsf);
                }
                catch (Exception ex) {
                    LOGGER.warn("Broken SchedulingListener: {}", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void planningFinished(BMLTSchedulingFinishedFeedback bpff) {
        List<BMLTSchedulingListener> list = this.planningListeners;
        synchronized (list) {
            for (BMLTSchedulingListener pl : this.planningListeners) {
                try {
                    pl.schedulingFinished(bpff);
                }
                catch (Exception ex) {
                    LOGGER.warn("Broken SchedulingListener: {}", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void warn(BMLWarningFeedback w) {
        w.setCharacterId(this.characterId);
        List<BMLWarningListener> list = this.warningListeners;
        synchronized (list) {
            for (BMLWarningListener wl : this.warningListeners) {
                try {
                    wl.warn(w);
                }
                catch (Exception ex) {
                    LOGGER.warn("Broken WarningListener: {}", (Throwable)ex);
                }
            }
        }
        this.bmlBlockManager.warn(w);
    }
}

