/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.bml.BMLSync;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.audioengine.AudioUnitPlanningException;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.TimedAbstractPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimedAbstractAudioUnit
extends TimedAbstractPlanUnit {
    private static Logger logger = LoggerFactory.getLogger((String)TimedAbstractAudioUnit.class.getName());
    protected InputStream inputStream;
    private double duration;
    protected double systemStartTime;
    protected double bmlStartTime;
    private TimePeg startPeg;
    private TimePeg endPeg;

    public TimedAbstractAudioUnit(FeedbackManager bfm, BMLBlockPeg bbPeg, InputStream inputStream, String bmlId, String id) {
        super(bfm, bbPeg, bmlId, id);
        this.inputStream = inputStream;
    }

    public TimePeg getStartPeg() {
        return this.startPeg;
    }

    public void setStartPeg(TimePeg startSync) {
        this.startPeg = startSync;
    }

    public TimePeg getEndPeg() {
        return this.endPeg;
    }

    public void setEndPeg(TimePeg endSync) {
        this.endPeg = endSync;
    }

    public void setStart(TimePeg start) {
        this.startPeg = start;
    }

    public void setEnd(TimePeg end) {
        this.endPeg = end;
    }

    public void stop() {
        if (this.isPlaying()) {
            this.setState(TimedPlanUnitState.DONE);
        }
    }

    @Override
    public double getStartTime() {
        if (this.startPeg == null) {
            return -1.7976931348623157E308;
        }
        return this.startPeg.getGlobalValue();
    }

    @Override
    public double getEndTime() {
        if (this.endPeg == null || this.endPeg.getGlobalValue() == -1.7976931348623157E308) {
            double startTime = this.getStartTime();
            if (startTime != -1.7976931348623157E308) {
                return startTime + this.getPreferedDuration();
            }
        } else {
            return this.endPeg.getGlobalValue();
        }
        return -1.7976931348623157E308;
    }

    @Override
    public void setTimePeg(String syncId, TimePeg peg) {
        if (BMLSync.isBMLSync((String)syncId)) {
            if (BMLSync.get((String)syncId).isAfter(BMLSync.STROKE)) {
                this.setEndPeg(peg);
            } else {
                this.setStartPeg(peg);
            }
        } else {
            logger.warn("Can't set TimePeg on non-BML sync {}", (Object)syncId);
        }
    }

    @Override
    public boolean hasValidTiming() {
        if (this.getStartTime() > this.getEndTime()) {
            return false;
        }
        if (Math.abs(this.getEndTime() - this.getStartTime() - this.getPreferedDuration()) > 1.0E-4) {
            logger.debug("End time: {}", (Object)this.getEndTime());
            logger.debug("Start time: {}", (Object)this.getStartTime());
            logger.debug("End-start: {}", (Object)(this.getEndTime() - this.getStartTime()));
            logger.debug("Duration: {}", (Object)this.getPreferedDuration());
            return false;
        }
        return true;
    }

    @Override
    public double getPreferedDuration() {
        return this.duration;
    }

    protected void setupCache() throws AudioUnitPlanningException {
    }

    public void setup() throws AudioUnitPlanningException {
        this.setupCache();
    }

    protected void sendStartProgress(double time) {
        logger.debug("sendStartProgress");
        String bmlId = this.getBMLId();
        String behaviorId = this.getId();
        String syncId = "start";
        double bmlBlockTime = time - this.bmlBlockPeg.getValue();
        this.feedback(new BMLSyncPointProgressFeedback(bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "ready";
        this.feedback(new BMLSyncPointProgressFeedback(bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "stroke_start";
        this.feedback(new BMLSyncPointProgressFeedback(bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "stroke";
        this.feedback(new BMLSyncPointProgressFeedback(bmlId, behaviorId, syncId, bmlBlockTime, time));
    }

    public abstract void sendProgress(double var1, double var3);

    public void sendEndProgress(double time) {
        logger.debug("sendEndProgress");
        String bmlId = this.getBMLId();
        String behaviorId = this.getId();
        String syncId = "stroke_end";
        double bmlBlockTime = time - this.bmlBlockPeg.getValue();
        this.feedback(new BMLSyncPointProgressFeedback(bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "relax";
        this.feedback(new BMLSyncPointProgressFeedback(bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "end";
        this.feedback(new BMLSyncPointProgressFeedback(bmlId, behaviorId, syncId, bmlBlockTime, time));
    }

    public void setPrefferedDuration(double duration) {
        this.duration = duration;
    }

    @Override
    public TimePeg getTimePeg(String syncId) {
        if (syncId.equals("start")) {
            return this.startPeg;
        }
        if (syncId.equals("end")) {
            return this.endPeg;
        }
        return null;
    }
}

