/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.anticipator;

import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.anticipator.Anticipator;
import hmi.elckerlyc.anticipator.KeyInfo;
import hmi.physics.PhysicsSync;
import hmi.util.SystemClock;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Observable;
import java.util.Observer;

public class SpaceBarAnticipator
extends Anticipator
implements KeyListener,
KeyInfo {
    private TimePeg release = new TimePeg(BMLBlockPeg.GLOBALPEG);
    private TimePeg press = new TimePeg(BMLBlockPeg.GLOBALPEG);
    private SystemClock physicsClock;
    private boolean pressed = false;
    private SBAObservable observable = new SBAObservable();

    public void reset() {
        this.release.setGlobalValue(1.0E8);
        this.press.setGlobalValue(1.0E8);
    }

    public SpaceBarAnticipator() {
        this.reset();
        this.addSynchronisationPoint("release", this.release);
        this.addSynchronisationPoint("press", this.press);
    }

    public void addObserver(Observer o) {
        this.observable.addObserver(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPhysicsClock(SystemClock phClock) {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.physicsClock = phClock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32 && !this.pressed) {
            this.pressed = true;
            Object object = PhysicsSync.getSync();
            synchronized (object) {
                this.press.setGlobalValue(this.physicsClock.getMediaSeconds());
            }
            this.observable.setChanged();
            this.observable.notifyObservers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            this.pressed = false;
            Object object = PhysicsSync.getSync();
            synchronized (object) {
                this.release.setGlobalValue(this.physicsClock.getMediaSeconds());
            }
            this.observable.setChanged();
            this.observable.notifyObservers();
        }
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public boolean isPressed() {
        return this.pressed;
    }

    private static class SBAObservable
    extends Observable {
        private SBAObservable() {
        }

        @Override
        public void setChanged() {
            super.setChanged();
        }
    }
}

