/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.animation.SkeletonPose;
import hmi.animation.VJoint;
import hmi.animation.VObject;
import hmi.animation.VObjectTransformCopier;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.animationengine.mixed.MixedPlayer;
import hmi.elckerlyc.animationengine.mixed.MixedSystem;
import hmi.elckerlyc.planunit.PlanPlayer;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.world.WorldObjectManager;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalJoint;
import hmi.physics.PhysicalSegment;
import hmi.physics.PhysicsSync;
import hmi.physics.controller.PhysicalController;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimationPlayer
implements Player {
    private VJoint vPrev;
    private VJoint vCurr;
    private VJoint vNext;
    private VJoint vPredict;
    private PhysicalHumanoid pHuman;
    private VObjectTransformCopier votcCurrToPrev;
    private VObjectTransformCopier votcNextToCurr;
    private boolean prevValid;
    private ArrayList<PhysicalController> controllers = new ArrayList();
    private final PlanPlayer app;
    private final PlanPlayer appPredict;
    private ArrayList<MixedSystem> mSystems;
    private MixedPlayer mPlayer;
    private float stepTime;
    private SkeletonPose vPrevStartPose;
    private SkeletonPose vCurrStartPose;
    private SkeletonPose vNextStartPose;
    private boolean prevValidOld = false;
    protected WorldObjectManager woManager;
    private Logger logger = LoggerFactory.getLogger((String)AnimationPlayer.class.getName());

    public AnimationPlayer(VJoint vP, VJoint vC, VJoint vN, VJoint vPred, ArrayList<MixedSystem> m, float h, PlanPlayer planPlayer, PlanPlayer predPlanPlayer) {
        this(vP, vC, vN, vPred, m, h, null, planPlayer, predPlanPlayer);
    }

    public AnimationPlayer(VJoint vP, VJoint vC, VJoint vN, VJoint vPred, ArrayList<MixedSystem> m, float h, WorldObjectManager wom, PlanPlayer planPlayer, PlanPlayer predPlanPlayer) {
        this.vPrev = vP;
        this.vCurr = vC;
        this.vNext = vN;
        this.woManager = wom;
        this.vPredict = vPred;
        VJoint[] emptyArray = new VJoint[]{};
        this.vPrevStartPose = new SkeletonPose((VObject[])this.vPrev.getParts().toArray(emptyArray), "TR");
        this.vCurrStartPose = new SkeletonPose((VObject[])this.vCurr.getParts().toArray(emptyArray), "TR");
        this.vNextStartPose = new SkeletonPose((VObject[])this.vNext.getParts().toArray(emptyArray), "TR");
        this.vPrevStartPose.setFromTarget();
        this.vCurrStartPose.setFromTarget();
        this.vNextStartPose.setFromTarget();
        this.mSystems = m;
        this.pHuman = this.mSystems.get(0).getPHuman();
        this.pHuman.setEnabled(true);
        this.votcNextToCurr = VObjectTransformCopier.newInstanceFromVJointTree((VJoint)this.vNext, (VJoint)this.vCurr, (String)"T1R");
        this.votcCurrToPrev = VObjectTransformCopier.newInstanceFromVJointTree((VJoint)this.vCurr, (VJoint)this.vPrev, (String)"T1R");
        this.mPlayer = new MixedPlayer(this.mSystems.get(0), this.vPrev, this.vCurr, this.vNext);
        this.mPlayer.setH(h);
        this.stepTime = h;
        this.app = planPlayer;
        this.appPredict = predPlanPlayer;
        this.prevValid = false;
    }

    @Override
    public synchronized void interruptBehaviour(String bmlId, String id, double globalTime) {
        this.app.interruptPlanUnit(bmlId, id, globalTime);
        this.appPredict.interruptPlanUnit(bmlId, id, 0.0);
    }

    public WorldObjectManager getWoManager() {
        return this.woManager;
    }

    public synchronized void predict(double time) {
        this.logger.debug("Predicting at {}", (Object)time);
        this.appPredict.play(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void reset(double time) {
        this.prevValid = false;
        this.vPrevStartPose.setToTarget();
        this.vCurrStartPose.setToTarget();
        this.vNextStartPose.setToTarget();
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            for (PhysicalController p : this.controllers) {
                p.reset();
            }
            for (MixedSystem ms : this.mSystems) {
                ms.reset(this.vNext);
            }
        }
        this.app.reset(time);
        this.appPredict.reset(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setResetPose() {
        this.vNextStartPose.setFromTarget();
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            for (MixedSystem ms : this.mSystems) {
                ms.setResetPose(this.vNext);
                ms.reset(this.vNext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void play(double prevTime) {
        this.controllers.clear();
        this.prevValidOld = this.prevValid;
        if (this.prevValid) {
            this.votcCurrToPrev.copyConfig();
            this.votcNextToCurr.copyConfig();
            this.app.play(prevTime);
        } else {
            this.app.play(prevTime);
            this.votcNextToCurr.copyConfig();
            this.votcCurrToPrev.copyConfig();
            this.prevValid = true;
        }
        ArrayList<String> controlledJoints = new ArrayList<String>();
        for (PhysicalController p : this.controllers) {
            for (String jid : p.getRequiredJointIDs()) {
                if (controlledJoints.contains(jid)) continue;
                controlledJoints.add(jid);
            }
        }
        ArrayList<String> desiredJoints = new ArrayList<String>();
        for (PhysicalController p : this.controllers) {
            for (String jid : p.getDesiredJointIDs()) {
                if (desiredJoints.contains(jid) || controlledJoints.contains(jid)) continue;
                desiredJoints.add(jid);
            }
        }
        MixedSystem bestMatch = this.mPlayer.getSystem();
        int jointsInPH = Integer.MAX_VALUE;
        int nrOfDesiredJoints = -1;
        boolean foundMatch = false;
        for (MixedSystem m : this.mSystems) {
            PhysicalHumanoid ph = m.getPHuman();
            boolean foundAll = true;
            for (String jid : controlledJoints) {
                boolean found = false;
                if (ph.getRootSegment() != null && ph.getRootSegment().getSid().equals(jid)) {
                    found = true;
                    break;
                }
                for (PhysicalJoint pj : ph.getJoints()) {
                    if (!pj.getName().equals(jid)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                foundAll = false;
                break;
            }
            if (!foundAll) continue;
            int dJoints = 0;
            block10: for (String jid : desiredJoints) {
                if (ph.getRootSegment() != null && ph.getRootSegment().getSid().equals(jid)) {
                    ++dJoints;
                    continue;
                }
                for (PhysicalJoint pj : ph.getJoints()) {
                    if (!pj.getName().equals(jid)) continue;
                    ++dJoints;
                    continue block10;
                }
            }
            if (dJoints > nrOfDesiredJoints) {
                nrOfDesiredJoints = dJoints;
                bestMatch = m;
                jointsInPH = ph.getJoints().size();
                foundMatch = true;
                continue;
            }
            if (dJoints != nrOfDesiredJoints || ph.getJoints().size() >= jointsInPH) continue;
            bestMatch = m;
            jointsInPH = ph.getJoints().size();
            foundMatch = true;
        }
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            if (!foundMatch) {
                this.logger.warn("Could not find a mixed system that contains joints: {} ", controlledJoints);
            }
            if (bestMatch != this.mPlayer.getSystem()) {
                this.logger.debug("Switching system {}", (Object)prevTime);
                this.mPlayer.switchSystem(bestMatch, this.stepTime, this.vPrev, this.vCurr, this.vNext, this.prevValidOld);
                this.pHuman.setEnabled(false);
                this.pHuman = this.mPlayer.getSystem().getPHuman();
                this.pHuman.setEnabled(true);
                for (PhysicalController p : this.controllers) {
                    p.setPhysicalHumanoid(this.pHuman);
                }
            }
            this.mPlayer.play(this.stepTime);
            this.pHuman.updateCOM(this.stepTime);
            for (PhysicalController p : this.controllers) {
                p.setPhysicalHumanoid(this.pHuman);
                p.update((double)this.stepTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void copyPhysics() {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.pHuman.copy();
            float[] q = new float[4];
            float[] tr = new float[3];
            for (PhysicalSegment ps : this.pHuman.getSegments()) {
                VJoint vC = this.vCurr.getPart(ps.getSid());
                VJoint vN = this.vNext.getPart(ps.getSid());
                vC.getRotation(q);
                vN.setRotation(q);
                if (!ps.getSid().equals("HumanoidRoot")) continue;
                vC.getTranslation(tr);
                vN.setTranslation(tr);
            }
        }
    }

    public synchronized ArrayList<PhysicalController> getControllers() {
        return this.controllers;
    }

    public VJoint getVNext() {
        return this.vNext;
    }

    public VJoint getVPrev() {
        return this.vPrev;
    }

    public VJoint getVCurr() {
        return this.vCurr;
    }

    public VJoint getVPredict() {
        return this.vPredict;
    }

    public synchronized PhysicalHumanoid getPHuman() {
        return this.pHuman;
    }

    public synchronized float getStepTime() {
        return this.stepTime;
    }

    public ArrayList<MixedSystem> getMixedSystems() {
        return this.mSystems;
    }

    @Override
    public void setBMLBlockState(String bmlId, TimedPlanUnitState state) {
        this.app.setBMLBlockState(bmlId, state);
        this.appPredict.setBMLBlockState(bmlId, state);
    }

    @Override
    public void interruptBehaviourBlock(String bmlId, double time) {
        this.app.interruptBehaviourBlock(bmlId, time);
        this.appPredict.interruptBehaviourBlock(bmlId, 0.0);
    }

    @Override
    public void shutdown() {
    }
}

