/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.activate;

import hmi.bml.core.Behaviour;
import hmi.bml.ext.bmlt.BMLTActivateBehaviour;
import hmi.elckerlyc.AbstractPlanner;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.activate.TimedActivateUnit;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.scheduler.BMLScheduler;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import java.util.ArrayList;
import java.util.List;

public class ActivatePlanner
extends AbstractPlanner {
    private BMLScheduler scheduler;

    public ActivatePlanner(FeedbackManager bfm, BMLScheduler s, PlanManager planManager) {
        this(bfm, planManager);
        this.scheduler = s;
    }

    public ActivatePlanner(FeedbackManager bfm, PlanManager planManager) {
        super(bfm, planManager);
    }

    public void setScheduler(BMLScheduler s) {
        this.scheduler = s;
    }

    @Override
    public List<SyncAndTimePeg> addBehaviour(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sac, TimedPlanUnit planElement) throws BehaviourPlanningException {
        if (!(b instanceof BMLTActivateBehaviour)) {
            throw new BehaviourPlanningException(b, "Behaviour is not a BMLTActivateBehaviour");
        }
        BMLTActivateBehaviour ab = (BMLTActivateBehaviour)b;
        TimedActivateUnit au = planElement == null ? new TimedActivateUnit(this.fbManager, bbPeg, b.getBmlId(), b.id, ab.getTarget(), this.scheduler) : (TimedActivateUnit)planElement;
        this.validateSacs(b, sac);
        au.setStartPeg(sac.get((int)0).peg);
        this.planManager.addPlanUnit(au);
        ArrayList<SyncAndTimePeg> list = new ArrayList<SyncAndTimePeg>();
        list.add(new SyncAndTimePeg(b.getBmlId(), b.id, "start", sac.get((int)0).peg));
        return list;
    }

    private void validateSacs(Behaviour b, List<TimePegAndConstraint> sac) throws BehaviourPlanningException {
        if (sac.size() > 1) {
            throw new BehaviourPlanningException(b, "Multiple synchronization constraints on to activate behavior " + b);
        }
        if (!sac.get((int)0).syncId.equals("start")) {
            throw new BehaviourPlanningException(b, "Activate behavior " + b + " has a synchronization constraint other than start.");
        }
    }

    @Override
    public TimedActivateUnit resolveSynchs(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sac) throws BehaviourPlanningException {
        TimedActivateUnit iu = new TimedActivateUnit(this.fbManager, bbPeg, b.getBmlId(), b.id, b.getStringParameterValue("target"), this.scheduler);
        this.validateSacs(b, sac);
        TimePegAndConstraint sacStart = sac.get(0);
        if (sacStart.peg.getGlobalValue() == -1.7976931348623157E308) {
            sacStart.peg.setLocalValue(0.0);
        }
        TimePeg start = sacStart.offset == 0.0 ? sacStart.peg : new OffsetPeg(sacStart.peg, -sacStart.offset);
        iu.setStartPeg(start);
        return iu;
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedBehaviours() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(BMLTActivateBehaviour.class);
        return list;
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedDescriptionExtensions() {
        return new ArrayList<Class<? extends Behaviour>>();
    }

    @Override
    public double getRigidity(Behaviour beh) {
        return 0.0;
    }
}

