/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.scheduler;

import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.scheduler.BMLScheduler;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BMLBlock {
    private final String bmlId;
    private final BMLScheduler scheduler;
    private AtomicReference<TimedPlanUnitState> state = new AtomicReference();
    private static Logger logger = LoggerFactory.getLogger((String)BMLBlock.class.getName());
    private final ConcurrentHashMap<String, Set<String>> behaviorSyncsPassed = new ConcurrentHashMap();
    private final Set<String> appendSet = new CopyOnWriteArraySet<String>();
    private final Set<String> onStartSet = new CopyOnWriteArraySet<String>();
    private final Set<String> droppedBehaviours = new CopyOnWriteArraySet<String>();

    public Set<String> getOnStartSet() {
        return Collections.unmodifiableSet(this.onStartSet);
    }

    public BMLBlock(String id, BMLScheduler s, Set<String> appendAfter, Set<String> onStart) {
        this.bmlId = id;
        this.scheduler = s;
        this.appendSet.addAll(appendAfter);
        this.onStartSet.addAll(onStart);
        this.state.set(TimedPlanUnitState.IN_PREP);
    }

    public BMLBlock(String id, BMLScheduler s) {
        this(id, s, new HashSet<String>(), new HashSet<String>());
    }

    public void clear() {
        this.droppedBehaviours.clear();
    }

    public void update(double time, Set<String> finishedBMLBlocks, Set<String> allBlocks) {
        if (this.state.get() == TimedPlanUnitState.LURKING) {
            this.updateFromLurking(finishedBMLBlocks, allBlocks);
        } else if (this.state.get() == TimedPlanUnitState.IN_EXEC || this.state.get() == TimedPlanUnitState.SUBSIDING) {
            this.updateFromExecOrSubSiding(time);
        }
    }

    private void updateFromLurking(Set<String> finishedBMLBlocks, Set<String> allBlocks) {
        this.appendSet.retainAll(allBlocks);
        for (String apId : this.appendSet) {
            if (finishedBMLBlocks.contains(apId)) continue;
            return;
        }
        this.scheduler.startBlock(this.bmlId);
    }

    private boolean isFinished(double timeStamp) {
        for (String behId : this.scheduler.getBehaviours(this.bmlId)) {
            if (this.droppedBehaviours.contains(behId)) continue;
            logger.debug("checking isFinished {}:{}", (Object)this.bmlId, (Object)behId);
            Set<String> finishedInfo = this.behaviorSyncsPassed.get(behId);
            if (finishedInfo == null) {
                return false;
            }
            if (finishedInfo.contains("end")) continue;
            return false;
        }
        return true;
    }

    public void behaviorProgress(String behaviorId, String syncId) {
        Set<String> behInfo = this.behaviorSyncsPassed.get(behaviorId);
        if (behInfo == null) {
            behInfo = new HashSet<String>();
            this.behaviorSyncsPassed.put(behaviorId, behInfo);
        }
        behInfo.add(syncId);
    }

    private void updateFromExecOrSubSiding(double timeStamp) {
        if (this.isFinished(timeStamp)) {
            logger.debug("bml block {} finished", (Object)this.bmlId);
            this.state.set(TimedPlanUnitState.DONE);
            this.scheduler.blockStopFeedback(this.bmlId);
        }
    }

    public void setState(TimedPlanUnitState state) {
        this.state.set(state);
    }

    public TimedPlanUnitState getState() {
        return this.state.get();
    }

    public void dropBehaviours(Set<String> behs) {
        this.droppedBehaviours.addAll(behs);
    }

    public String getBMLId() {
        return this.bmlId;
    }
}

