/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import hmi.bml.BMLSync;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.SyncPointNotFoundException;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.elckerlyc.planunit.PlanUnitFloatParameterNotFoundException;
import hmi.elckerlyc.planunit.PlanUnitParameterNotFoundException;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimedAbstractPlanUnit
implements TimedPlanUnit {
    protected final BMLBlockPeg bmlBlockPeg;
    private boolean subUnit;
    private final String id;
    private final String bmlBlockId;
    private static Logger logger = LoggerFactory.getLogger((String)TimedAbstractPlanUnit.class.getName());
    private final List<String> availableSyncs = new ArrayList<String>();
    private final AtomicReference<TimedPlanUnitState> state;
    protected final FeedbackManager fbManager;

    public TimedAbstractPlanUnit(FeedbackManager fbm, BMLBlockPeg bmlPeg, String bmlId, String behId, boolean sub) {
        this.fbManager = fbm;
        this.bmlBlockPeg = bmlPeg;
        this.id = behId;
        this.bmlBlockId = bmlId;
        this.state = new AtomicReference<TimedPlanUnitState>(TimedPlanUnitState.IN_PREP);
        this.subUnit = sub;
        this.availableSyncs.add(BMLSync.START.getId());
        this.availableSyncs.add(BMLSync.READY.getId());
        this.availableSyncs.add(BMLSync.STROKE_START.getId());
        this.availableSyncs.add(BMLSync.STROKE.getId());
        this.availableSyncs.add(BMLSync.STROKE_END.getId());
        this.availableSyncs.add(BMLSync.RELAX.getId());
        this.availableSyncs.add(BMLSync.END.getId());
    }

    public TimedAbstractPlanUnit(FeedbackManager fbm, BMLBlockPeg bmlPeg, String bmlId, String behId) {
        this(fbm, bmlPeg, bmlId, behId, false);
    }

    public void setSubUnit(boolean sub) {
        this.subUnit = sub;
    }

    protected PlanUnitFloatParameterNotFoundException wrapIntoPlanUnitFloatParameterNotFoundException(ParameterNotFoundException ex) {
        PlanUnitFloatParameterNotFoundException pup = new PlanUnitFloatParameterNotFoundException(this.getBMLId(), this.getId(), ex.getParamId());
        pup.initCause(ex);
        return pup;
    }

    protected PlanUnitParameterNotFoundException wrapIntoPlanUnitParameterNotFoundException(ParameterNotFoundException ex) {
        PlanUnitParameterNotFoundException pup = new PlanUnitParameterNotFoundException(this.getBMLId(), this.getId(), ex.getParamId());
        pup.initCause(ex);
        return pup;
    }

    protected abstract void playUnit(double var1) throws TimedPlanUnitPlayException;

    protected abstract void stopUnit(double var1) throws TimedPlanUnitPlayException;

    protected void sendFeedback(String syncId, double time) {
        String bmlId = this.getBMLId();
        String behaviorId = this.getId();
        String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        double bmlBlockTime = time - this.bmlBlockPeg.getValue();
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
    }

    protected void startUnit(double time) throws TimedPlanUnitPlayException {
    }

    @Override
    public boolean isSubUnit() {
        return this.subUnit;
    }

    @Override
    public String getReplacementGroup() {
        return null;
    }

    @Override
    public final void play(double time) throws TimedPlanUnitPlayException {
        if (!this.isPlaying()) {
            return;
        }
        logger.debug("playing planunit {}:{}, {}", new Object[]{this.bmlBlockId, this.id, this.getClass().getCanonicalName()});
        if (time < this.getStartTime() || this.getStartTime() == -1.7976931348623157E308) {
            if (!this.isSubUnit()) {
                throw new TimedPlanUnitPlayException("Calling play with time :" + time + "< startTime(" + this.getStartTime() + ").", this);
            }
            logger.warn("Calling sub unit play with time : {} < startTime({}).", (Object)time, (Object)this.getStartTime());
        }
        if (time < this.getEndTime() || this.getEndTime() == -1.7976931348623157E308) {
            logger.debug("Entering playUnit {}:{}", (Object)this.bmlBlockId, (Object)this.id);
            this.playUnit(time);
        } else {
            this.stop(time);
        }
    }

    @Override
    public final void stop(double time) throws TimedPlanUnitPlayException {
        logger.debug("Entering TimedAbstractPlanUnit {}:{} stop", (Object)this.getBMLId(), (Object)this.getBMLId());
        if (this.isPlaying()) {
            logger.debug("TimedAbstractPlanUnit stop");
            this.stopUnit(time);
            logger.debug("TimedAbstractPlanUnit stopUnit done");
        }
        this.setState(TimedPlanUnitState.DONE);
    }

    @Override
    public final void start(double time) throws TimedPlanUnitPlayException {
        logger.debug("attempting to start planunit {}:{}", (Object)this.bmlBlockId, (Object)this.id);
        if (!this.isLurking()) {
            return;
        }
        if (time > this.getEndTime() && this.getEndTime() != -1.7976931348623157E308) {
            this.setState(TimedPlanUnitState.DONE);
            if (!this.isSubUnit()) {
                throw new TimedPlanUnitPlayException("Starting behaviour " + this.getClass().getName() + " with id " + this.bmlBlockId + ":" + this.id + " at time " + time + " past end time " + this.getEndTime() + ", behaviour was never executed.", this);
            }
            logger.warn("Starting sub plan unit behaviour {} with id {}:{} at time {} past end time {}, behaviour was never executed.", new Object[]{this.getClass().getName(), this.bmlBlockId, this.id, time, this.getEndTime()});
        } else {
            this.setState(TimedPlanUnitState.IN_EXEC);
            this.startUnit(time);
        }
        logger.debug("started planunit {}:{}", (Object)this.bmlBlockId, (Object)this.id);
    }

    @Override
    public BMLBlockPeg getBMLBlockPeg() {
        return this.bmlBlockPeg;
    }

    @Override
    public String getBMLId() {
        return this.bmlBlockId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void feedback(List<BMLSyncPointProgressFeedback> fbs) {
        this.fbManager.feedback(fbs);
    }

    @Override
    public void feedback(BMLSyncPointProgressFeedback fb) {
        this.fbManager.feedback(fb);
    }

    @Override
    public void setState(TimedPlanUnitState newState) {
        this.state.set(newState);
    }

    @Override
    public TimedPlanUnitState getState() {
        return this.state.get();
    }

    @Override
    public boolean isPlaying() {
        return this.state.get().isPlaying();
    }

    @Override
    public boolean isLurking() {
        return this.state.get().isLurking();
    }

    @Override
    public boolean isDone() {
        return this.state.get().isDone();
    }

    @Override
    public double getPreferedDuration() {
        return 0.0;
    }

    @Override
    public double getRelativeTime(String syncId) throws SyncPointNotFoundException {
        if (syncId.equals("start") || syncId.equals("ready") || syncId.equals("stroke-start") || syncId.equals("stroke")) {
            return 0.0;
        }
        if (syncId.equals("stroke-end") || syncId.equals("relax") || syncId.equals("end")) {
            return 1.0;
        }
        throw new SyncPointNotFoundException(this.getBMLId(), this.getId(), syncId);
    }

    @Override
    public double getTime(String syncId) {
        if (syncId.equals("start") || syncId.equals("ready") || syncId.equals("stroke-start") || syncId.equals("stroke")) {
            return this.getStartTime();
        }
        if (syncId.equals("stroke-end") || syncId.equals("relax") || syncId.equals("end")) {
            return this.getEndTime();
        }
        return -1.7976931348623157E308;
    }

    @Override
    public List<String> getAvailableSyncs() {
        return this.availableSyncs;
    }

    @Override
    public void setParameterValue(String paramId, String value) throws ParameterException {
        throw new PlanUnitParameterNotFoundException(this.getBMLId(), this.getId(), paramId);
    }

    @Override
    public void setFloatParameterValue(String paramId, float value) throws ParameterException {
        throw new PlanUnitFloatParameterNotFoundException(this.getBMLId(), this.getId(), paramId);
    }

    @Override
    public float getFloatParameterValue(String paramId) throws ParameterException {
        throw new PlanUnitFloatParameterNotFoundException(this.getBMLId(), this.getId(), paramId);
    }

    @Override
    public String getParameterValue(String paramId) throws ParameterException {
        throw new PlanUnitParameterNotFoundException(this.getBMLId(), this.getId(), paramId);
    }
}

