/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.transitions;

import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.transitions.TransitionMU;
import hmi.math.NumMath;
import hmi.math.Quat4f;
import hmi.math.QuatCurve;
import hmi.math.Vec3f;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HermiteSplineTransitionMU
extends TransitionMU {
    private AnimationPlayer player;
    private float[] qStart;
    private float[] qStartP;
    private float[] qStartN;
    private float[] qEnd;
    private float[] wStart;
    private float[] wEnd;
    private float[] qrate;
    private float[] q;
    private static Logger logger = LoggerFactory.getLogger((String)HermiteSplineTransitionMU.class.getName());

    public HermiteSplineTransitionMU() {
    }

    public HermiteSplineTransitionMU(List<VJoint> j, AnimationPlayer p) {
        this.player = p;
        this.joints = j;
        this.qStart = new float[4 * j.size()];
        this.qStartP = new float[4 * j.size()];
        this.qStartN = new float[4 * j.size()];
        this.qEnd = new float[4 * j.size()];
        this.qrate = new float[4 * j.size()];
        this.q = new float[4 * j.size()];
        this.wStart = new float[3 * j.size()];
        this.wEnd = new float[3 * j.size()];
        this.qEnd = new float[4 * j.size()];
        this.wEnd = new float[3 * j.size()];
    }

    @Override
    public TransitionMU copy(AnimationPlayer p) {
        if (this.joints != null) {
            ArrayList<VJoint> newJoints = new ArrayList<VJoint>();
            for (VJoint vj : this.joints) {
                VJoint newJ = p.getVNext().getPart(vj.getSid());
                if (newJ == null) continue;
                this.joints.add(newJ);
            }
            return new HermiteSplineTransitionMU(newJoints, p);
        }
        return new HermiteSplineTransitionMU(p.getVNext().getParts(), p);
    }

    @Override
    public void play(double t) {
        int i;
        for (i = 0; i < this.joints.size(); ++i) {
            QuatCurve.hermite((float[])this.qStart, (int)(i * 4), (float[])this.qEnd, (int)(i * 4), (float[])this.wStart, (int)(i * 3), (float[])this.wEnd, (int)(i * 3), (float)((float)t), (float[])this.q, (int)(i * 4));
        }
        i = 0;
        for (VJoint j : this.joints) {
            j.setRotation(this.q, i);
            i += 4;
        }
    }

    @Override
    public void setStartPose() {
        VJoint vCurrStart = this.player.getVNext();
        VJoint vPrevStart = this.player.getVPrev();
        VJoint vNextStart = this.player.getVCurr();
        int i = 0;
        for (VJoint v : this.joints) {
            vCurrStart.getPart(v.getSid()).getRotation(this.qStart, i);
            i += 4;
        }
        i = 0;
        for (VJoint v : this.joints) {
            vPrevStart.getPart(v.getSid()).getRotation(this.qStartP, i);
            i += 4;
        }
        i = 0;
        for (VJoint v : this.joints) {
            vNextStart.getPart(v.getSid()).getRotation(this.qStartN, i);
            i += 4;
        }
        for (i = 0; i < this.joints.size() * 4; ++i) {
            this.qrate[i] = NumMath.diff((float)this.qStartP[i], (float)this.qStartN[i], (float)this.player.getStepTime());
        }
        i = 0;
        for (VJoint v : this.joints) {
            Quat4f.setAngularVelocityFromQuat4f((float[])this.wStart, (int)(i * 3), (float[])this.qStart, (int)(i * 4), (float[])this.qrate, (int)(i * 4));
            logger.debug(v.getId());
            logger.debug("wStart({}) {}", (Object)i, (Object)Vec3f.toString((float[])this.wStart, (int)(i * 3)));
            logger.debug("wEnd({}) {}", (Object)i, (Object)Vec3f.toString((float[])this.wEnd, (int)(i * 3)));
            logger.debug("qEnd({}) {}", (Object)i, (Object)Quat4f.toString((float[])this.qEnd, (int)(i * 4)));
            logger.debug("qStart({}) {}", (Object)i, (Object)Quat4f.toString((float[])this.qStart, (int)(i * 4)));
            logger.debug("qStartP({}) {}", (Object)i, (Object)Quat4f.toString((float[])this.qStartP, (int)(i * 4)));
            logger.debug("qStartN({}) {}", (Object)i, (Object)Quat4f.toString((float[])this.qStartN, (int)(i * 4)));
            logger.debug("qrate({}) {}", (Object)i, (Object)Quat4f.toString((float[])this.qrate, (int)(i * 4)));
            logger.debug("-------------------------------------------------------");
            ++i;
        }
    }

    @Override
    public void setEndPose(double endTime, double duration) {
        for (int i = 0; i < this.joints.size(); ++i) {
            Vec3f.scale((float)((float)duration), (float[])this.wStart, (int)(i * 3));
        }
        int nrOfJoints = this.joints.size();
        float[] qPrev = new float[nrOfJoints * 4];
        float[] qNext = new float[nrOfJoints * 4];
        float[] qrate = new float[nrOfJoints * 4];
        int i = 0;
        VJoint pred = this.player.getVPredict();
        this.player.predict(endTime);
        for (VJoint j : this.joints) {
            pred.getPart(j.getSid()).getRotation(qPrev, i);
            i += 4;
        }
        i = 0;
        this.player.predict(endTime + (double)0.001f);
        for (VJoint j : this.joints) {
            pred.getPart(j.getSid()).getRotation(this.qEnd, i);
            i += 4;
        }
        i = 0;
        this.player.predict(endTime + (double)0.002f);
        for (VJoint j : this.joints) {
            pred.getPart(j.getSid()).getRotation(qNext, i);
            i += 4;
        }
        for (i = 0; i < nrOfJoints * 4; ++i) {
            qrate[i] = NumMath.diff((float)qPrev[i], (float)qNext[i], (float)0.001f);
        }
        for (i = 0; i < nrOfJoints; ++i) {
            Quat4f.setAngularVelocityFromQuat4f((float[])this.wEnd, (int)(i * 3), (float[])this.qEnd, (int)(i * 4), (float[])qrate, (int)(i * 4));
            Vec3f.scale((float)((float)duration), (float[])this.wEnd);
        }
    }
}

