/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.procanimation;

import hmi.animation.VJoint;
import hmi.bml.BMLSync;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.KeyPositionManager;
import hmi.elckerlyc.animationengine.KeyPositionManagerImpl;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.animationengine.procanimation.GestureUnit;
import hmi.elckerlyc.animationengine.procanimation.ProcAnimationGestureTMU;
import hmi.elckerlyc.animationengine.procanimation.ProcAnimationMU;
import hmi.elckerlyc.animationengine.transitions.SlerpTransitionToPoseMU;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.InvalidParameterException;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.util.Resources;
import hmi.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcAnimationGestureMU
implements GestureUnit {
    private static Logger logger = LoggerFactory.getLogger((String)ProcAnimationGestureMU.class.getName());
    private ProcAnimationMU gestureUnit = new ProcAnimationMU();
    private KeyPositionManager keyPositionManager = new KeyPositionManagerImpl();
    private SlerpTransitionToPoseMU prepUnit;
    private SlerpTransitionToPoseMU relaxUnit;
    private VJoint vStart;
    private VJoint vNext;
    private Resources resource;
    private double preStrokeHoldDuration = 0.0;
    private double postStrokeHoldDuration = 0.0;

    private boolean inGesturePhase(String syncId) {
        return !syncId.equals(BMLSync.START.getId()) && !syncId.equals(BMLSync.END.getId()) && !syncId.equals(BMLSync.READY.getId()) && !syncId.equals(BMLSync.RELAX.getId());
    }

    @Override
    public void addKeyPosition(KeyPosition kp) {
        this.keyPositionManager.addKeyPosition(kp);
        if (this.inGesturePhase(kp.id)) {
            this.gestureUnit.addKeyPosition(kp);
        }
    }

    public void setGestureUnit(ProcAnimationMU pa) {
        this.gestureUnit = pa;
        for (KeyPosition kp : this.gestureUnit.getKeyPositions()) {
            if (!this.inGesturePhase(kp.id)) continue;
            this.keyPositionManager.addKeyPosition(kp);
        }
        this.setPreStrokeHoldDuration();
        this.setPostStrokeHoldDuration();
        this.gestureUnit.setup(this.vNext);
    }

    public void setAnimationPlayer(AnimationPlayer ap) {
        this.vStart = ap.getVCurr();
        this.vNext = ap.getVNext();
        this.gestureUnit.setup(this.vNext);
    }

    public void setVStartJoint(VJoint vj) {
        this.vStart = vj;
    }

    public void setVNext(VJoint vj) {
        this.vNext = vj;
    }

    @Override
    public List<KeyPosition> getKeyPositions() {
        return this.keyPositionManager.getKeyPositions();
    }

    @Override
    public void setKeyPositions(List<KeyPosition> p) {
        this.keyPositionManager.setKeyPositions(p);
        for (KeyPosition kp : p) {
            if (!this.inGesturePhase(kp.id)) continue;
            this.gestureUnit.addKeyPosition(kp);
        }
    }

    @Override
    public KeyPosition getKeyPosition(String id) {
        return this.keyPositionManager.getKeyPosition(id);
    }

    @Override
    public void removeKeyPosition(String id) {
        this.keyPositionManager.removeKeyPosition(id);
        if (this.inGesturePhase(id)) {
            this.gestureUnit.removeKeyPosition(id);
        }
    }

    private void setPostStrokeHoldDuration() {
        KeyPosition strokeEnd = this.keyPositionManager.getKeyPosition(BMLSync.STROKE_END.getId());
        KeyPosition strokeStart = this.keyPositionManager.getKeyPosition(BMLSync.STROKE_START.getId());
        if (strokeEnd != null && strokeStart != null) {
            double val = strokeEnd.time + (strokeEnd.time - strokeStart.time) * this.postStrokeHoldDuration;
            KeyPosition kp = this.getKeyPosition(BMLSync.RELAX.getId());
            if (kp == null) {
                this.addKeyPosition(new KeyPosition(BMLSync.RELAX.getId(), val, 1.0));
            } else {
                kp.time = val;
            }
        }
    }

    private void setPreStrokeHoldDuration() {
        KeyPosition strokeEnd = this.keyPositionManager.getKeyPosition(BMLSync.STROKE_END.getId());
        KeyPosition strokeStart = this.keyPositionManager.getKeyPosition(BMLSync.STROKE_START.getId());
        if (strokeEnd != null && strokeStart != null) {
            double val = strokeStart.time - (strokeEnd.time - strokeStart.time) * this.preStrokeHoldDuration;
            KeyPosition kp = this.getKeyPosition(BMLSync.READY.getId());
            if (kp == null) {
                this.addKeyPosition(new KeyPosition(BMLSync.READY.getId(), val, 1.0));
            } else {
                kp.time = val;
            }
        }
    }

    @Override
    public void setFloatParameterValue(String name, float value) throws ParameterException {
        if (name.equals("preStrokeHoldDuration")) {
            this.preStrokeHoldDuration = value;
            this.setPreStrokeHoldDuration();
        } else if (name.equals("postStrokeHoldDuration")) {
            this.postStrokeHoldDuration = value;
            this.setPostStrokeHoldDuration();
        } else {
            this.gestureUnit.setFloatParameterValue(name, value);
        }
    }

    @Override
    public void setParameterValue(String name, String value) throws ParameterException {
        if (name.equals("file")) {
            try {
                ProcAnimationMU mu = new ProcAnimationMU();
                mu.readXML(this.resource.getReader(value));
                mu.setParameters(this.gestureUnit.getParameters());
                this.setGestureUnit(mu);
                this.gestureUnit.setup(this.vNext);
            }
            catch (IOException e) {
                throw new InvalidParameterException(name, value, e);
            }
        } else if (StringUtil.isNumeric((String)value)) {
            this.setFloatParameterValue(name, Float.parseFloat(value));
        } else {
            this.gestureUnit.setParameterValue(name, value);
        }
    }

    @Override
    public String getParameterValue(String name) throws ParameterException {
        return this.gestureUnit.getParameterValue(name);
    }

    @Override
    public float getFloatParameterValue(String name) throws ParameterException {
        return this.gestureUnit.getFloatParameterValue(name);
    }

    @Override
    public void play(double t) throws MUPlayException {
        double strokeStartTime = this.keyPositionManager.getKeyPosition((String)BMLSync.STROKE_START.getId()).time;
        double readyTime = this.keyPositionManager.getKeyPosition((String)BMLSync.READY.getId()).time;
        double relaxTime = this.keyPositionManager.getKeyPosition((String)BMLSync.RELAX.getId()).time;
        double strokeEndTime = this.keyPositionManager.getKeyPosition((String)BMLSync.STROKE_END.getId()).time;
        double relaxDuration = 1.0 - relaxTime;
        logger.debug("time: {}", (Object)t);
        if (t < readyTime) {
            this.prepUnit.play(t / readyTime);
            logger.debug("prepUnit.play: {}", (Object)(t / readyTime));
        } else if (t > relaxTime) {
            this.relaxUnit.play((t - relaxTime) / relaxDuration);
            logger.debug("relaxUnit.play: {}", (Object)((t - relaxTime) / relaxDuration));
        } else if (t > strokeStartTime && t < strokeEndTime) {
            this.gestureUnit.play(t);
            logger.debug("gestureUnit.play: {}", (Object)t);
        }
    }

    @Override
    public TimedMotionUnit createTMU(FeedbackManager bbm, BMLBlockPeg bmlBlockPeg, String bmlId, String id) {
        return new ProcAnimationGestureTMU(bbm, bmlBlockPeg, bmlId, id, this);
    }

    @Override
    public MotionUnit getPredictor(VJoint vPredict) {
        return null;
    }

    @Override
    public double getPreferedDuration() {
        return this.gestureUnit.getPrefDuration();
    }

    @Override
    public ProcAnimationGestureMU copy(AnimationPlayer p) {
        ProcAnimationGestureMU copy = new ProcAnimationGestureMU();
        copy.setAnimationPlayer(p);
        copy.resource = this.resource;
        ProcAnimationMU copyPA = this.gestureUnit.copy(p);
        for (KeyPosition kp : copyPA.getKeyPositions()) {
            copyPA.removeKeyPosition(kp.id);
        }
        copy.setGestureUnit(copyPA);
        for (KeyPosition kp : this.getKeyPositions()) {
            copy.addKeyPosition(kp.deepCopy());
        }
        return copy;
    }

    @Override
    public String getReplacementGroup() {
        return this.gestureUnit.getReplacementGroup();
    }

    public void setupTransitionUnits() {
        VJoint v2;
        int i = 0;
        float[] startPose = new float[this.gestureUnit.getControlledJoints().size() * 4];
        float[] strokeStartPose = new float[this.gestureUnit.getControlledJoints().size() * 4];
        float[] relaxStartPose = new float[this.gestureUnit.getControlledJoints().size() * 4];
        VJoint vCopy = this.vStart.copyTree("copy-");
        ProcAnimationMU copyProc = this.gestureUnit.copy(vCopy);
        for (VJoint v : this.gestureUnit.getControlledJoints()) {
            v.getRotation(startPose, i);
            i += 4;
        }
        i = 0;
        copyProc.play(this.getKeyPosition((String)BMLSync.STROKE_START.getId()).time + 0.01);
        for (VJoint v : this.gestureUnit.getControlledJoints()) {
            v2 = vCopy.getPartBySid(v.getSid());
            v2.getRotation(strokeStartPose, i);
            i += 4;
        }
        i = 0;
        copyProc.play(this.getKeyPosition((String)BMLSync.STROKE_END.getId()).time - 0.01);
        for (VJoint v : this.gestureUnit.getControlledJoints()) {
            v2 = vCopy.getPartBySid(v.getSid());
            v2.getRotation(relaxStartPose, i);
            i += 4;
        }
        ArrayList<VJoint> startPoseJoint = new ArrayList<VJoint>();
        for (VJoint vj : this.gestureUnit.getControlledJoints()) {
            startPoseJoint.add(this.vStart.getPartBySid(vj.getSid()));
        }
        this.prepUnit = new SlerpTransitionToPoseMU(this.gestureUnit.getControlledJoints(), startPoseJoint, strokeStartPose);
        this.relaxUnit = new SlerpTransitionToPoseMU(this.gestureUnit.getControlledJoints(), startPoseJoint, startPose);
        this.prepUnit.setStartPose();
        this.relaxUnit.setStartPose(relaxStartPose);
    }

    @Override
    public void setResource(Resources r) {
        this.resource = r;
    }
}

