/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.mixed;

import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.mixed.Branch;
import hmi.elckerlyc.animationengine.mixed.MixedSystem;
import hmi.math.NumMath;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.math.Vec4f;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalJoint;
import hmi.physics.PhysicsSync;
import hmi.physics.inversedynamics.IDSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedPlayer {
    private Logger logger = LoggerFactory.getLogger((String)MixedPlayer.class.getName());
    private VJoint[] hPrevS;
    private VJoint[] hCurrS;
    private VJoint[] hNextS;
    private float[] qPrev;
    private float[] qCurr;
    private float[] qNext;
    private float[] qDiff;
    private float[] qDiff2;
    private float[] w;
    private float[] wDiff;
    private float[] q = new float[4];
    private float[] q1 = new float[4];
    private float[] q2 = new float[4];
    private float[] v = new float[3];
    private float[] v1 = new float[3];
    private float[] v2 = new float[3];
    private MixedSystem system;
    private int kinJoints = 0;
    private float h;
    public static final float DEFAULTH = 0.001f;

    public MixedPlayer(MixedSystem sys, VJoint hPrev, VJoint hCurr, VJoint hNext) {
        this.setSystem(sys, hPrev, hCurr, hNext);
        this.h = 0.001f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPrevCurrNextFromPhysicalHuman(PhysicalHumanoid ph, VJoint vPrev, VJoint vCurr, VJoint vNext) {
        float[] w = new float[3];
        for (PhysicalJoint pj : ph.getJoints()) {
            if (this.system.getPHuman().getJoint(pj.getName()) != null) continue;
            Object object = PhysicsSync.getSync();
            synchronized (object) {
                pj.getRotation(this.q);
                pj.getAngularVelocity(w);
            }
            vNext.getPart(pj.getName()).setRotation(this.q);
            this.logger.debug("Setting rotation of {} {}", (Object)pj.getName(), (Object)Quat4f.toString((float[])this.q));
            float theta = Vec3f.length((float[])w) * this.h;
            if (theta > 0.0f) {
                Vec3f.normalize((float[])w);
                Vec3f.scale((float)((float)(-Math.sin((double)theta * 0.5))), (float[])w);
                Quat4f.set((float[])this.q1, (float)((float)Math.cos((double)theta * 0.5)), (float)w[0], (float)w[1], (float)w[2]);
                Quat4f.mul((float[])this.q2, (float[])this.q, (float[])this.q1);
                vCurr.getPart(pj.getName()).setRotation(this.q2);
                Quat4f.mul((float[])this.q2, (float[])this.q1);
                vPrev.getPart(pj.getName()).setRotation(this.q2);
                continue;
            }
            vCurr.getPart(pj.getName()).setRotation(this.q);
            vPrev.getPart(pj.getName()).setRotation(this.q);
        }
        if (ph.getRootSegment() != null && this.system.getPHuman().getSegment(ph.getRootSegment().getSid()) == null) {
            Object i$ = PhysicsSync.getSync();
            synchronized (i$) {
                ph.getRootSegment().box.getRotation(this.q);
                ph.getRootSegment().getAngularVelocity(w);
                ph.getRootSegment().box.getTranslation(this.v2);
            }
            vNext.getPart(ph.getRootSegment().getSid()).setRotation(this.q);
            float theta = Vec3f.length((float[])w) * this.h;
            if (theta > 0.0f) {
                Vec3f.normalize((float[])w);
                Vec3f.scale((float)((float)(-Math.sin((double)theta * 0.5))), (float[])w);
                Quat4f.set((float[])this.q1, (float)((float)Math.cos((double)theta * 0.5)), (float)w[0], (float)w[1], (float)w[2]);
                Quat4f.mul((float[])this.q2, (float[])this.q, (float[])this.q1);
                vCurr.getPart(ph.getRootSegment().getSid()).setRotation(this.q2);
                Quat4f.mul((float[])this.q2, (float[])this.q1);
                vPrev.getPart(ph.getRootSegment().getSid()).setRotation(this.q2);
            } else {
                vCurr.getPart(ph.getRootSegment().getSid()).setRotation(this.q);
                vPrev.getPart(ph.getRootSegment().getSid()).setRotation(this.q);
            }
            Vec3f.set((float[])this.v1, (float[])ph.getRootSegment().startJointOffset);
            Quat4f.transformVec3f((float[])this.q, (float[])this.v1);
            Vec3f.add((float[])this.v, (float[])this.v1, (float[])this.v2);
            vPrev.getPart(ph.getRootSegment().getSid()).setTranslation(this.v);
            vCurr.getPart(ph.getRootSegment().getSid()).setTranslation(this.v);
            vNext.getPart(ph.getRootSegment().getSid()).setTranslation(this.v);
        }
    }

    public void setSystem(MixedSystem sys, VJoint hPrev, VJoint hCurr, VJoint hNext) {
        this.system = sys;
        int i = 0;
        for (Branch b : this.system.getBranches()) {
            i += b.idBranch.getSegments().length;
        }
        this.kinJoints = i;
        this.hPrevS = new VJoint[this.kinJoints];
        this.hCurrS = new VJoint[this.kinJoints];
        this.hNextS = new VJoint[this.kinJoints];
        i = 0;
        for (Branch b : this.system.getBranches()) {
            for (IDSegment seg : b.idBranch.getSegments()) {
                this.hPrevS[i] = hPrev.getPart(seg.name);
                this.hCurrS[i] = hCurr.getPart(seg.name);
                this.hNextS[i] = hNext.getPart(seg.name);
                ++i;
            }
        }
        this.qPrev = new float[4 * this.kinJoints];
        this.qCurr = new float[4 * this.kinJoints];
        this.qNext = new float[4 * this.kinJoints];
        this.qDiff = new float[4 * this.kinJoints];
        this.qDiff2 = new float[4 * this.kinJoints];
        this.w = new float[3 * this.kinJoints];
        this.wDiff = new float[3 * this.kinJoints];
    }

    public float getH() {
        return this.h;
    }

    public void setH(float hNew) {
        this.h = hNew;
    }

    public void setMassOffset() {
        for (int i = 0; i < this.kinJoints; ++i) {
            this.hCurrS[i].getRotation(this.qCurr, i * 4);
        }
        this.system.setMassOffset(this.qCurr);
    }

    public void reset(VJoint vj) {
        this.system.reset(vj);
    }

    private void calculateKinematics() {
        int i;
        for (i = 0; i < this.kinJoints; ++i) {
            this.hPrevS[i].getRotation(this.qPrev, i * 4);
            this.hCurrS[i].getRotation(this.qCurr, i * 4);
            if (Vec4f.dot((float[])this.qPrev, (int)(i * 4), (float[])this.qCurr, (int)(i * 4)) < 0.0f) {
                Vec4f.scale((float)-1.0f, (float[])this.qCurr, (int)(i * 4));
                this.logger.debug("Flipping cur quat");
            }
            this.hNextS[i].getRotation(this.qNext, i * 4);
            if (!(Vec4f.dot((float[])this.qCurr, (int)(i * 4), (float[])this.qNext, (int)(i * 4)) < 0.0f)) continue;
            Vec4f.scale((float)-1.0f, (float[])this.qNext, (int)(i * 4));
            this.logger.debug("Flipping next quat");
        }
        for (i = 0; i < this.kinJoints * 4; ++i) {
            this.qDiff[i] = NumMath.diff((float)this.qPrev[i], (float)this.qNext[i], (float)this.h);
            this.qDiff2[i] = NumMath.diff2((float)this.qPrev[i], (float)this.qCurr[i], (float)this.qNext[i], (float)this.h);
        }
        for (i = 0; i < this.kinJoints; ++i) {
            Quat4f.setAngularVelocityFromQuat4f((float[])this.w, (int)(i * 3), (float[])this.qCurr, (int)(i * 4), (float[])this.qDiff, (int)(i * 4));
            Quat4f.setAngularAccelerationFromQuat4f((float[])this.wDiff, (int)(i * 3), (float[])this.qCurr, (int)(i * 4), (float[])this.qDiff2, (int)(i * 4));
        }
    }

    public void switchSystem(MixedSystem sys, float timeDiff, VJoint prev, VJoint curr, VJoint next, boolean switchPrevCurrNext) {
        PhysicalHumanoid ph = this.system.getPHuman();
        this.calculateKinematics();
        sys.set(this.system, this.qCurr, this.w);
        this.setSystem(sys, prev, curr, next);
        if (switchPrevCurrNext) {
            this.setPrevCurrNextFromPhysicalHuman(ph, prev, curr, next);
        }
    }

    public void play(float timeDiff) {
        this.calculateKinematics();
        this.system.time(timeDiff, this.qCurr, this.w, this.wDiff);
    }

    public MixedSystem getSystem() {
        return this.system;
    }
}

