/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.mixed;

import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.math.SpatialVec;
import hmi.math.Vec3f;
import hmi.physics.PhysicalSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connector {
    private Logger logger = LoggerFactory.getLogger((String)Connector.class.getName());
    private PhysicalSegment segment;
    private float[] connectionPoint = new float[3];
    private float[] vel = new float[3];
    private float[] aVel = new float[3];
    private float[] aAcc = new float[3];
    private float[] acc = new float[3];
    private float[] prevVel = new float[3];
    private float[] prevAVel = new float[3];
    private float[] rTorque = new float[3];
    private float[] bodyRotation = new float[4];
    private float[] tempS = new float[6];
    private float[] tempRot = new float[4];
    private float[] tempPos = new float[3];
    private float[] mTemp = new float[16];
    private boolean isFirst = false;
    private float k = 1.0f;
    private static final float MAX_REACTIVE_TORQUE = 1000.0f;

    public Connector(PhysicalSegment seg, float[] p, float kmul) {
        this.segment = seg;
        float[] pos = new float[3];
        seg.box.getTranslation(pos);
        Vec3f.set((float[])this.connectionPoint, (float[])p);
        Vec3f.sub((float[])this.connectionPoint, (float[])pos);
        this.k = kmul;
        this.reset();
    }

    public void setFeedbackRatio(float kmul) {
        this.k = kmul;
    }

    public void reset() {
        Vec3f.set((float[])this.prevVel, (float)0.0f, (float)0.0f, (float)0.0f);
        Vec3f.set((float[])this.prevAVel, (float)0.0f, (float)0.0f, (float)0.0f);
        this.isFirst = true;
    }

    public void setVel(Connector c) {
        Vec3f.set((float[])this.prevVel, (float[])c.prevVel);
        Vec3f.set((float[])this.prevAVel, (float[])c.prevAVel);
    }

    public void getWorldTransform(float[] m) {
        Mat4f.setIdentity((float[])m);
        this.segment.box.getRotation(this.tempRot);
        Mat4f.setRotation((float[])m, (float[])this.tempRot);
        this.segment.box.getTranslation(this.tempPos);
        Mat4f.setTranslation((float[])m, (float[])this.tempPos);
        Mat4f.setIdentity((float[])this.mTemp);
        Mat4f.setTranslation((float[])this.mTemp, (float[])this.connectionPoint);
        Mat4f.mul((float[])m, (float[])this.mTemp);
    }

    public void getWorldPosition(float[] dst) {
        this.segment.box.getPointRelPosition(dst, this.connectionPoint);
    }

    public void getRelVelocity(float[] velocity) {
        this.segment.box.getRelativePointVelocity(velocity, this.connectionPoint);
    }

    public void getVelocity(float[] velocity) {
        this.segment.box.getPointVelocity(velocity, this.connectionPoint);
    }

    public void getAvelocity(float[] aVelocity) {
        this.segment.box.getAngularVelocity(aVelocity);
    }

    public void getSpatialVelocityAndAcceleration(float timeDiff, float[] spatialV, float[] spatialA, float[] spatialG) {
        this.segment.box.getRotation(this.bodyRotation);
        Quat4f.inverse((float[])this.bodyRotation);
        this.segment.box.getAngularVelocity(this.aVel);
        Quat4f.transformVec3f((float[])this.bodyRotation, (float[])this.aVel);
        this.segment.box.getRelativePointVelocity(this.vel, this.connectionPoint);
        SpatialVec.set((float[])spatialV, (float[])this.aVel, (float[])this.vel);
        if (timeDiff == 0.0f) {
            SpatialVec.set((float[])spatialA, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        } else {
            if (this.isFirst) {
                Vec3f.set((float[])this.prevVel, (float[])this.vel);
                Vec3f.set((float[])this.prevAVel, (float[])this.aVel);
                this.isFirst = false;
            }
            Vec3f.set((float[])this.acc, (float[])this.vel);
            Vec3f.sub((float[])this.acc, (float[])this.prevVel);
            Vec3f.scale((float)(1.0f / timeDiff), (float[])this.acc);
            Vec3f.set((float[])this.aAcc, (float[])this.aVel);
            Vec3f.sub((float[])this.aAcc, (float[])this.prevAVel);
            Vec3f.scale((float)(1.0f / timeDiff), (float[])this.aAcc);
            SpatialVec.setAcc((float[])spatialA, (float[])this.aVel, (float[])this.vel, (float[])this.aAcc, (float[])this.acc);
        }
        SpatialVec.set((float[])this.tempS, (float[])spatialG);
        Quat4f.transformVec3f((float[])this.bodyRotation, (int)0, (float[])this.tempS, (int)3);
        SpatialVec.sub((float[])spatialA, (float[])this.tempS);
        Vec3f.set((float[])this.prevVel, (float[])this.vel);
        Vec3f.set((float[])this.prevAVel, (float[])this.aVel);
    }

    public void getSpatialVelocityAndAcceleration(float timeDiff, float[] spatialV, float[] spatialA) {
        this.segment.box.getRotation(this.bodyRotation);
        Quat4f.inverse((float[])this.bodyRotation);
        this.segment.box.getAngularVelocity(this.aVel);
        Quat4f.transformVec3f((float[])this.bodyRotation, (float[])this.aVel);
        this.segment.box.getRelativePointVelocity(this.vel, this.connectionPoint);
        SpatialVec.set((float[])spatialV, (float[])this.aVel, (float[])this.vel);
        if (timeDiff == 0.0f) {
            SpatialVec.set((float[])spatialA, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            return;
        }
        Vec3f.set((float[])this.acc, (float[])this.vel);
        Vec3f.sub((float[])this.acc, (float[])this.prevVel);
        Vec3f.scale((float)(1.0f / timeDiff), (float[])this.acc);
        Vec3f.set((float[])this.aAcc, (float[])this.aVel);
        Vec3f.sub((float[])this.aAcc, (float[])this.prevAVel);
        Vec3f.scale((float)(1.0f / timeDiff), (float[])this.aAcc);
        SpatialVec.setAcc((float[])spatialA, (float[])this.aVel, (float[])this.vel, (float[])this.aAcc, (float[])this.acc);
        Vec3f.set((float[])this.prevVel, (float[])this.vel);
        Vec3f.set((float[])this.prevAVel, (float[])this.aVel);
    }

    public void applyReactiveTorque(float[] q, float[] f) {
        Vec3f.set((float[])this.rTorque, (float[])f);
        float[] q2 = new float[4];
        Quat4f.set((float[])q2, (float[])q);
        float[] force = new float[3];
        Vec3f.set((float[])force, (int)0, (float[])f, (int)3);
        Quat4f.transformVec3f((float[])q2, (float[])force);
        Quat4f.transformVec3f((float[])q2, (float[])this.rTorque);
        Vec3f.scale((float)(-this.k), (float[])force);
        Vec3f.scale((float)(-this.k), (float[])this.rTorque);
        if (Vec3f.lengthSq((float[])this.rTorque) < 1000000.0f) {
            this.segment.box.addRelTorque(this.rTorque[0], this.rTorque[1], this.rTorque[2]);
            this.segment.box.addRelForceAtRelPos(force, this.connectionPoint);
            float[] t = new float[3];
            float[] fo = new float[3];
            this.segment.box.getForce(fo);
            this.segment.box.getTorque(t);
        } else {
            this.logger.warn("Max reactive torque exceeded: {} on {}, {}", new Object[]{Float.valueOf(Vec3f.length((float[])this.rTorque)), this.getStartSegment().getSid(), Vec3f.toString((float[])this.connectionPoint)});
        }
    }

    public PhysicalSegment getStartSegment() {
        return this.segment;
    }
}

