/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.gesturebinding;

import hmi.bml.core.Behaviour;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.gesturebinding.MotionUnitParameterDefault;
import hmi.elckerlyc.animationengine.gesturebinding.MotionUnitSpec;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.util.Resources;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GestureBinding
extends XMLStructureAdapter {
    private ArrayList<MotionUnitSpec> specs = new ArrayList();
    private final Resources resources;
    private final Logger logger = LoggerFactory.getLogger((String)GestureBinding.class.getName());
    private final FeedbackManager fbManager;
    private static final String XMLTAG = "gesturebinding";

    public GestureBinding(Resources r, FeedbackManager fbm) {
        this.fbManager = fbm;
        this.resources = r;
    }

    public List<TimedMotionUnit> getMotionUnit(BMLBlockPeg bbPeg, Behaviour b, AnimationPlayer player) {
        ArrayList<TimedMotionUnit> mus = new ArrayList<TimedMotionUnit>();
        for (MotionUnitSpec s : this.specs) {
            if (!s.getType().equals(b.getXMLTag()) || (s.getSpecnamespace() != null || b.getNamespace() != null) && (s.getSpecnamespace() == null || !s.getSpecnamespace().equals(b.getNamespace()))) continue;
            if (!s.satisfiesConstraints(b)) {
                this.logger.debug("Constraint mismatch");
                continue;
            }
            MotionUnit muCopy = s.motionUnit.copy(player);
            TimedMotionUnit tmu = muCopy.createTMU(this.fbManager, bbPeg, b.getBmlId(), b.id);
            for (MotionUnitParameterDefault mupc : s.getParameterDefaults()) {
                try {
                    muCopy.setParameterValue(mupc.name, mupc.value);
                }
                catch (ParameterException e) {
                    this.logger.warn("Error in setting default value in getMotionUnit " + (Object)((Object)mupc), (Throwable)e);
                }
                this.logger.debug("Setting parameter {}  to default {}", (Object)mupc.name, (Object)mupc.value);
            }
            for (String param : s.getParameters()) {
                if (!b.specifiesParameter(param)) continue;
                String value = b.getStringParameterValue(param);
                try {
                    muCopy.setParameterValue(s.getParameter(param), value);
                }
                catch (ParameterException e) {
                    this.logger.warn("Error in parameter mapping in getMotionUnit, parameter " + param, (Throwable)e);
                }
                this.logger.debug("Setting parameter {} mapped to {}", (Object)param, (Object)s.getParameter(param));
            }
            mus.add(tmu);
        }
        return mus;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (!tag.equals(MotionUnitSpec.xmlTag())) continue;
            MotionUnitSpec muSpec = new MotionUnitSpec(this.resources);
            muSpec.readXML(tokenizer);
            if (muSpec.motionUnit != null) {
                this.specs.add(muSpec);
                continue;
            }
            this.logger.warn("Dropped motion unit spec because we could not construct the motion unit");
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

